package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ToStringOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableToStringOperator.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableToStringOperator.of()}.
 */
@Generated(from = "ToStringOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableToStringOperator
    implements ToStringOperator {
  private final Expression expression;

  private ImmutableToStringOperator(Expression expression) {
    this.expression = Objects.requireNonNull(expression, "expression");
  }

  private ImmutableToStringOperator(ImmutableToStringOperator original, Expression expression) {
    this.expression = expression;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @Override
  public Expression getExpression() {
    return expression;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ToStringOperator#getExpression() expression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableToStringOperator withExpression(Expression value) {
    if (this.expression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "expression");
    return new ImmutableToStringOperator(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableToStringOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableToStringOperator
        && equalTo((ImmutableToStringOperator) another);
  }

  private boolean equalTo(ImmutableToStringOperator another) {
    return expression.equals(another.expression);
  }

  /**
   * Computes a hash code from attributes: {@code expression}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + expression.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ToStringOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ToStringOperator")
        .omitNullValues()
        .add("expression", expression)
        .toString();
  }

  /**
   * Construct a new immutable {@code ToStringOperator} instance.
   * @param expression The value for the {@code expression} attribute
   * @return An immutable ToStringOperator instance
   */
  public static ImmutableToStringOperator of(Expression expression) {
    return new ImmutableToStringOperator(expression);
  }

  /**
   * Creates an immutable copy of a {@link ToStringOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ToStringOperator instance
   */
  public static ImmutableToStringOperator copyOf(ToStringOperator instance) {
    if (instance instanceof ImmutableToStringOperator) {
      return (ImmutableToStringOperator) instance;
    }
    return ImmutableToStringOperator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableToStringOperator ImmutableToStringOperator}.
   * <pre>
   * ImmutableToStringOperator.builder()
   *    .expression(io.dialob.session.engine.program.model.Expression) // required {@link ToStringOperator#getExpression() expression}
   *    .build();
   * </pre>
   * @return A new ImmutableToStringOperator builder
   */
  public static ImmutableToStringOperator.Builder builder() {
    return new ImmutableToStringOperator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableToStringOperator ImmutableToStringOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ToStringOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EXPRESSION = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Expression expression;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ToStringOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ToStringOperator instance) {
      Objects.requireNonNull(instance, "instance");
      expression(instance.getExpression());
      return this;
    }

    /**
     * Initializes the value for the {@link ToStringOperator#getExpression() expression} attribute.
     * @param expression The value for expression 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expression(Expression expression) {
      this.expression = Objects.requireNonNull(expression, "expression");
      initBits &= ~INIT_BIT_EXPRESSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableToStringOperator ImmutableToStringOperator}.
     * @return An immutable instance of ToStringOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableToStringOperator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableToStringOperator(null, expression);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXPRESSION) != 0) attributes.add("expression");
      return "Cannot build ToStringOperator, some of required attributes are not set " + attributes;
    }
  }
}
