package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.program.model.Expression;
import io.dialob.session.engine.session.command.EventMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StringTemplateOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStringTemplateOperator.builder()}.
 */
@Generated(from = "StringTemplateOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStringTemplateOperator
    implements StringTemplateOperator {
  private final String template;
  private final ImmutableSet<EventMatcher> evalRequiredConditions;

  private ImmutableStringTemplateOperator(
      String template,
      ImmutableSet<EventMatcher> evalRequiredConditions) {
    this.template = template;
    this.evalRequiredConditions = evalRequiredConditions;
  }

  /**
   * @return The value of the {@code template} attribute
   */
  @Override
  public String getTemplate() {
    return template;
  }

  /**
   * @return The value of the {@code evalRequiredConditions} attribute
   */
  @Override
  public ImmutableSet<EventMatcher> getEvalRequiredConditions() {
    return evalRequiredConditions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StringTemplateOperator#getTemplate() template} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for template
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStringTemplateOperator withTemplate(String value) {
    String newValue = Objects.requireNonNull(value, "template");
    if (this.template.equals(newValue)) return this;
    return new ImmutableStringTemplateOperator(newValue, this.evalRequiredConditions);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StringTemplateOperator#getEvalRequiredConditions() evalRequiredConditions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStringTemplateOperator withEvalRequiredConditions(EventMatcher... elements) {
    ImmutableSet<EventMatcher> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableStringTemplateOperator(this.template, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StringTemplateOperator#getEvalRequiredConditions() evalRequiredConditions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of evalRequiredConditions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStringTemplateOperator withEvalRequiredConditions(Iterable<? extends EventMatcher> elements) {
    if (this.evalRequiredConditions == elements) return this;
    ImmutableSet<EventMatcher> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableStringTemplateOperator(this.template, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStringTemplateOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStringTemplateOperator
        && equalTo((ImmutableStringTemplateOperator) another);
  }

  private boolean equalTo(ImmutableStringTemplateOperator another) {
    return template.equals(another.template)
        && evalRequiredConditions.equals(another.evalRequiredConditions);
  }

  /**
   * Computes a hash code from attributes: {@code template}, {@code evalRequiredConditions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + template.hashCode();
    h += (h << 5) + evalRequiredConditions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StringTemplateOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StringTemplateOperator")
        .omitNullValues()
        .add("template", template)
        .add("evalRequiredConditions", evalRequiredConditions)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link StringTemplateOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StringTemplateOperator instance
   */
  public static ImmutableStringTemplateOperator copyOf(StringTemplateOperator instance) {
    if (instance instanceof ImmutableStringTemplateOperator) {
      return (ImmutableStringTemplateOperator) instance;
    }
    return ImmutableStringTemplateOperator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStringTemplateOperator ImmutableStringTemplateOperator}.
   * <pre>
   * ImmutableStringTemplateOperator.builder()
   *    .template(String) // required {@link StringTemplateOperator#getTemplate() template}
   *    .addEvalRequiredConditions|addAllEvalRequiredConditions(io.dialob.session.engine.session.command.EventMatcher) // {@link StringTemplateOperator#getEvalRequiredConditions() evalRequiredConditions} elements
   *    .build();
   * </pre>
   * @return A new ImmutableStringTemplateOperator builder
   */
  public static ImmutableStringTemplateOperator.Builder builder() {
    return new ImmutableStringTemplateOperator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStringTemplateOperator ImmutableStringTemplateOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StringTemplateOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TEMPLATE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String template;
    private ImmutableSet.Builder<EventMatcher> evalRequiredConditions = ImmutableSet.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.expr.arith.StringTemplateOperator} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StringTemplateOperator instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.Expression} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Expression instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof StringTemplateOperator) {
        StringTemplateOperator instance = (StringTemplateOperator) object;
        template(instance.getTemplate());
        if ((bits & 0x1L) == 0) {
          addAllEvalRequiredConditions(instance.getEvalRequiredConditions());
          bits |= 0x1L;
        }
      }
      if (object instanceof Expression) {
        Expression instance = (Expression) object;
        if ((bits & 0x1L) == 0) {
          addAllEvalRequiredConditions(instance.getEvalRequiredConditions());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link StringTemplateOperator#getTemplate() template} attribute.
     * @param template The value for template 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder template(String template) {
      this.template = Objects.requireNonNull(template, "template");
      initBits &= ~INIT_BIT_TEMPLATE;
      return this;
    }

    /**
     * Adds one element to {@link StringTemplateOperator#getEvalRequiredConditions() evalRequiredConditions} set.
     * @param element A evalRequiredConditions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEvalRequiredConditions(EventMatcher element) {
      this.evalRequiredConditions.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StringTemplateOperator#getEvalRequiredConditions() evalRequiredConditions} set.
     * @param elements An array of evalRequiredConditions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEvalRequiredConditions(EventMatcher... elements) {
      this.evalRequiredConditions.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StringTemplateOperator#getEvalRequiredConditions() evalRequiredConditions} set.
     * @param elements An iterable of evalRequiredConditions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder evalRequiredConditions(Iterable<? extends EventMatcher> elements) {
      this.evalRequiredConditions = ImmutableSet.builder();
      return addAllEvalRequiredConditions(elements);
    }

    /**
     * Adds elements to {@link StringTemplateOperator#getEvalRequiredConditions() evalRequiredConditions} set.
     * @param elements An iterable of evalRequiredConditions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEvalRequiredConditions(Iterable<? extends EventMatcher> elements) {
      this.evalRequiredConditions.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableStringTemplateOperator ImmutableStringTemplateOperator}.
     * @return An immutable instance of StringTemplateOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStringTemplateOperator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStringTemplateOperator(template, evalRequiredConditions.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TEMPLATE) != 0) attributes.add("template");
      return "Cannot build StringTemplateOperator, some of required attributes are not set " + attributes;
    }
  }
}
