package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NeOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNeOperator.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNeOperator.of()}.
 */
@Generated(from = "NeOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNeOperator<T> implements NeOperator<T> {
  private final Expression lhs;
  private final Expression rhs;

  private ImmutableNeOperator(
      Expression lhs,
      Expression rhs) {
    this.lhs = Objects.requireNonNull(lhs, "lhs");
    this.rhs = Objects.requireNonNull(rhs, "rhs");
  }

  private ImmutableNeOperator(
      ImmutableNeOperator<T> original,
      Expression lhs,
      Expression rhs) {
    this.lhs = lhs;
    this.rhs = rhs;
  }

  /**
   * @return left hand side expression of operator
   */
  @Override
  public Expression getLhs() {
    return lhs;
  }

  /**
   * @return right hand side expression of operator
   */
  @Override
  public Expression getRhs() {
    return rhs;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NeOperator#getLhs() lhs} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lhs
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNeOperator<T> withLhs(Expression value) {
    if (this.lhs == value) return this;
    Expression newValue = Objects.requireNonNull(value, "lhs");
    return new ImmutableNeOperator<>(this, newValue, this.rhs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NeOperator#getRhs() rhs} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rhs
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNeOperator<T> withRhs(Expression value) {
    if (this.rhs == value) return this;
    Expression newValue = Objects.requireNonNull(value, "rhs");
    return new ImmutableNeOperator<>(this, this.lhs, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNeOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNeOperator<?>
        && equalTo((ImmutableNeOperator<?>) another);
  }

  private boolean equalTo(ImmutableNeOperator<?> another) {
    return lhs.equals(another.lhs)
        && rhs.equals(another.rhs);
  }

  /**
   * Computes a hash code from attributes: {@code lhs}, {@code rhs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + lhs.hashCode();
    h += (h << 5) + rhs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NeOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NeOperator")
        .omitNullValues()
        .add("lhs", lhs)
        .add("rhs", rhs)
        .toString();
  }

  /**
   * Construct a new immutable {@code NeOperator} instance.
 * @param <T> generic parameter T
   * @param lhs The value for the {@code lhs} attribute
   * @param rhs The value for the {@code rhs} attribute
   * @return An immutable NeOperator instance
   */
  public static <T> ImmutableNeOperator<T> of(Expression lhs, Expression rhs) {
    return new ImmutableNeOperator<>(lhs, rhs);
  }

  /**
   * Creates an immutable copy of a {@link NeOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable NeOperator instance
   */
  public static <T> ImmutableNeOperator<T> copyOf(NeOperator<T> instance) {
    if (instance instanceof ImmutableNeOperator<?>) {
      return (ImmutableNeOperator<T>) instance;
    }
    return ImmutableNeOperator.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNeOperator ImmutableNeOperator}.
   * <pre>
   * ImmutableNeOperator.&amp;lt;T&amp;gt;builder()
   *    .lhs(io.dialob.session.engine.program.model.Expression) // required {@link NeOperator#getLhs() lhs}
   *    .rhs(io.dialob.session.engine.program.model.Expression) // required {@link NeOperator#getRhs() rhs}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableNeOperator builder
   */
  public static <T> ImmutableNeOperator.Builder<T> builder() {
    return new ImmutableNeOperator.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableNeOperator ImmutableNeOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NeOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_LHS = 0x1L;
    private static final long INIT_BIT_RHS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Expression lhs;
    private @Nullable Expression rhs;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NeOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(NeOperator<T> instance) {
      Objects.requireNonNull(instance, "instance");
      lhs(instance.getLhs());
      rhs(instance.getRhs());
      return this;
    }

    /**
     * Initializes the value for the {@link NeOperator#getLhs() lhs} attribute.
     * @param lhs The value for lhs 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> lhs(Expression lhs) {
      this.lhs = Objects.requireNonNull(lhs, "lhs");
      initBits &= ~INIT_BIT_LHS;
      return this;
    }

    /**
     * Initializes the value for the {@link NeOperator#getRhs() rhs} attribute.
     * @param rhs The value for rhs 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> rhs(Expression rhs) {
      this.rhs = Objects.requireNonNull(rhs, "rhs");
      initBits &= ~INIT_BIT_RHS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNeOperator ImmutableNeOperator}.
     * @return An immutable instance of NeOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNeOperator<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNeOperator<>(null, lhs, rhs);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LHS) != 0) attributes.add("lhs");
      if ((initBits & INIT_BIT_RHS) != 0) attributes.add("rhs");
      return "Cannot build NeOperator, some of required attributes are not set " + attributes;
    }
  }
}
