package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.session.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link IsAnsweredOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableIsAnsweredOperator.builder()}.
 */
@Generated(from = "IsAnsweredOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableIsAnsweredOperator
    implements IsAnsweredOperator {
  private final ItemId questionId;

  private ImmutableIsAnsweredOperator(ItemId questionId) {
    this.questionId = questionId;
  }

  /**
   * @return The value of the {@code questionId} attribute
   */
  @Override
  public ItemId getQuestionId() {
    return questionId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IsAnsweredOperator#getQuestionId() questionId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for questionId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIsAnsweredOperator withQuestionId(ItemId value) {
    if (this.questionId == value) return this;
    ItemId newValue = Objects.requireNonNull(value, "questionId");
    return new ImmutableIsAnsweredOperator(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIsAnsweredOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIsAnsweredOperator
        && equalTo((ImmutableIsAnsweredOperator) another);
  }

  private boolean equalTo(ImmutableIsAnsweredOperator another) {
    return questionId.equals(another.questionId);
  }

  /**
   * Computes a hash code from attributes: {@code questionId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + questionId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IsAnsweredOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("IsAnsweredOperator")
        .omitNullValues()
        .add("questionId", questionId)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link IsAnsweredOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IsAnsweredOperator instance
   */
  public static ImmutableIsAnsweredOperator copyOf(IsAnsweredOperator instance) {
    if (instance instanceof ImmutableIsAnsweredOperator) {
      return (ImmutableIsAnsweredOperator) instance;
    }
    return ImmutableIsAnsweredOperator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableIsAnsweredOperator ImmutableIsAnsweredOperator}.
   * <pre>
   * ImmutableIsAnsweredOperator.builder()
   *    .questionId(io.dialob.session.engine.session.model.ItemId) // required {@link IsAnsweredOperator#getQuestionId() questionId}
   *    .build();
   * </pre>
   * @return A new ImmutableIsAnsweredOperator builder
   */
  public static ImmutableIsAnsweredOperator.Builder builder() {
    return new ImmutableIsAnsweredOperator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableIsAnsweredOperator ImmutableIsAnsweredOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IsAnsweredOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_QUESTION_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable ItemId questionId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code IsAnsweredOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(IsAnsweredOperator instance) {
      Objects.requireNonNull(instance, "instance");
      questionId(instance.getQuestionId());
      return this;
    }

    /**
     * Initializes the value for the {@link IsAnsweredOperator#getQuestionId() questionId} attribute.
     * @param questionId The value for questionId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder questionId(ItemId questionId) {
      this.questionId = Objects.requireNonNull(questionId, "questionId");
      initBits &= ~INIT_BIT_QUESTION_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableIsAnsweredOperator ImmutableIsAnsweredOperator}.
     * @return An immutable instance of IsAnsweredOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIsAnsweredOperator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableIsAnsweredOperator(questionId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_QUESTION_ID) != 0) attributes.add("questionId");
      return "Cannot build IsAnsweredOperator, some of required attributes are not set " + attributes;
    }
  }
}
