package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DateMinusPeriodOperator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDateMinusPeriodOperator.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDateMinusPeriodOperator.of()}.
 */
@Generated(from = "DateMinusPeriodOperator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDateMinusPeriodOperator
    implements DateMinusPeriodOperator {
  private final Expression lhs;
  private final Expression rhs;

  private ImmutableDateMinusPeriodOperator(
      Expression lhs,
      Expression rhs) {
    this.lhs = Objects.requireNonNull(lhs, "lhs");
    this.rhs = Objects.requireNonNull(rhs, "rhs");
  }

  private ImmutableDateMinusPeriodOperator(
      ImmutableDateMinusPeriodOperator original,
      Expression lhs,
      Expression rhs) {
    this.lhs = lhs;
    this.rhs = rhs;
  }

  /**
   * @return left hand side expression of operator
   */
  @Override
  public Expression getLhs() {
    return lhs;
  }

  /**
   * @return right hand side expression of operator
   */
  @Override
  public Expression getRhs() {
    return rhs;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DateMinusPeriodOperator#getLhs() lhs} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lhs
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDateMinusPeriodOperator withLhs(Expression value) {
    if (this.lhs == value) return this;
    Expression newValue = Objects.requireNonNull(value, "lhs");
    return new ImmutableDateMinusPeriodOperator(this, newValue, this.rhs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DateMinusPeriodOperator#getRhs() rhs} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rhs
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDateMinusPeriodOperator withRhs(Expression value) {
    if (this.rhs == value) return this;
    Expression newValue = Objects.requireNonNull(value, "rhs");
    return new ImmutableDateMinusPeriodOperator(this, this.lhs, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDateMinusPeriodOperator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDateMinusPeriodOperator
        && equalTo((ImmutableDateMinusPeriodOperator) another);
  }

  private boolean equalTo(ImmutableDateMinusPeriodOperator another) {
    return lhs.equals(another.lhs)
        && rhs.equals(another.rhs);
  }

  /**
   * Computes a hash code from attributes: {@code lhs}, {@code rhs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + lhs.hashCode();
    h += (h << 5) + rhs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DateMinusPeriodOperator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DateMinusPeriodOperator")
        .omitNullValues()
        .add("lhs", lhs)
        .add("rhs", rhs)
        .toString();
  }

  /**
   * Construct a new immutable {@code DateMinusPeriodOperator} instance.
   * @param lhs The value for the {@code lhs} attribute
   * @param rhs The value for the {@code rhs} attribute
   * @return An immutable DateMinusPeriodOperator instance
   */
  public static ImmutableDateMinusPeriodOperator of(Expression lhs, Expression rhs) {
    return new ImmutableDateMinusPeriodOperator(lhs, rhs);
  }

  /**
   * Creates an immutable copy of a {@link DateMinusPeriodOperator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DateMinusPeriodOperator instance
   */
  public static ImmutableDateMinusPeriodOperator copyOf(DateMinusPeriodOperator instance) {
    if (instance instanceof ImmutableDateMinusPeriodOperator) {
      return (ImmutableDateMinusPeriodOperator) instance;
    }
    return ImmutableDateMinusPeriodOperator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDateMinusPeriodOperator ImmutableDateMinusPeriodOperator}.
   * <pre>
   * ImmutableDateMinusPeriodOperator.builder()
   *    .lhs(io.dialob.session.engine.program.model.Expression) // required {@link DateMinusPeriodOperator#getLhs() lhs}
   *    .rhs(io.dialob.session.engine.program.model.Expression) // required {@link DateMinusPeriodOperator#getRhs() rhs}
   *    .build();
   * </pre>
   * @return A new ImmutableDateMinusPeriodOperator builder
   */
  public static ImmutableDateMinusPeriodOperator.Builder builder() {
    return new ImmutableDateMinusPeriodOperator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDateMinusPeriodOperator ImmutableDateMinusPeriodOperator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DateMinusPeriodOperator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LHS = 0x1L;
    private static final long INIT_BIT_RHS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Expression lhs;
    private @Nullable Expression rhs;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DateMinusPeriodOperator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DateMinusPeriodOperator instance) {
      Objects.requireNonNull(instance, "instance");
      lhs(instance.getLhs());
      rhs(instance.getRhs());
      return this;
    }

    /**
     * Initializes the value for the {@link DateMinusPeriodOperator#getLhs() lhs} attribute.
     * @param lhs The value for lhs 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder lhs(Expression lhs) {
      this.lhs = Objects.requireNonNull(lhs, "lhs");
      initBits &= ~INIT_BIT_LHS;
      return this;
    }

    /**
     * Initializes the value for the {@link DateMinusPeriodOperator#getRhs() rhs} attribute.
     * @param rhs The value for rhs 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder rhs(Expression rhs) {
      this.rhs = Objects.requireNonNull(rhs, "rhs");
      initBits &= ~INIT_BIT_RHS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDateMinusPeriodOperator ImmutableDateMinusPeriodOperator}.
     * @return An immutable instance of DateMinusPeriodOperator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDateMinusPeriodOperator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDateMinusPeriodOperator(null, lhs, rhs);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LHS) != 0) attributes.add("lhs");
      if ((initBits & INIT_BIT_RHS) != 0) attributes.add("rhs");
      return "Cannot build DateMinusPeriodOperator, some of required attributes are not set " + attributes;
    }
  }
}
