package io.dialob.session.engine.program.expr.arith;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.rule.parser.api.ValueType;
import io.dialob.session.engine.program.model.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Constant}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConstant.builder()}.
 */
@Generated(from = "Constant", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConstant<T> implements Constant<T> {
  private final T value;
  private final ValueType valueType;

  private ImmutableConstant(T value, ValueType valueType) {
    this.value = value;
    this.valueType = valueType;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public T getValue() {
    return value;
  }

  /**
   * @return The value of the {@code valueType} attribute
   */
  @Override
  public ValueType getValueType() {
    return valueType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Constant#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConstant<T> withValue(T value) {
    if (this.value == value) return this;
    T newValue = Objects.requireNonNull(value, "value");
    return new ImmutableConstant<>(newValue, this.valueType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Constant#getValueType() valueType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConstant<T> withValueType(ValueType value) {
    if (this.valueType == value) return this;
    ValueType newValue = Objects.requireNonNull(value, "valueType");
    return new ImmutableConstant<>(this.value, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConstant} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConstant<?>
        && equalTo((ImmutableConstant<?>) another);
  }

  private boolean equalTo(ImmutableConstant<?> another) {
    return value.equals(another.value)
        && valueType.equals(another.valueType);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code valueType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + valueType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Constant} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Constant")
        .omitNullValues()
        .add("value", value)
        .add("valueType", valueType)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Constant} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Constant instance
   */
  public static <T> ImmutableConstant<T> copyOf(Constant<T> instance) {
    if (instance instanceof ImmutableConstant<?>) {
      return (ImmutableConstant<T>) instance;
    }
    return ImmutableConstant.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConstant ImmutableConstant}.
   * <pre>
   * ImmutableConstant.&amp;lt;T&amp;gt;builder()
   *    .value(T) // required {@link Constant#getValue() value}
   *    .valueType(io.dialob.rule.parser.api.ValueType) // required {@link Constant#getValueType() valueType}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableConstant builder
   */
  public static <T> ImmutableConstant.Builder<T> builder() {
    return new ImmutableConstant.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableConstant ImmutableConstant}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Constant", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_VALUE = 0x1L;
    private static final long INIT_BIT_VALUE_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable T value;
    private @Nullable ValueType valueType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.expr.arith.Constant} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(Constant<T> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.session.engine.program.model.Expression} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(Expression instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof Constant<?>) {
        Constant<T> instance = (Constant<T>) object;
        value(instance.getValue());
        if ((bits & 0x1L) == 0) {
          valueType(instance.getValueType());
          bits |= 0x1L;
        }
      }
      if (object instanceof Expression) {
        Expression instance = (Expression) object;
        if ((bits & 0x1L) == 0) {
          valueType(instance.getValueType());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Constant#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> value(T value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link Constant#getValueType() valueType} attribute.
     * @param valueType The value for valueType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> valueType(ValueType valueType) {
      this.valueType = Objects.requireNonNull(valueType, "valueType");
      initBits &= ~INIT_BIT_VALUE_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConstant ImmutableConstant}.
     * @return An immutable instance of Constant
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConstant<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConstant<>(value, valueType);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_VALUE_TYPE) != 0) attributes.add("valueType");
      return "Cannot build Constant, some of required attributes are not set " + attributes;
    }
  }
}
