package io.dialob.session.engine.program.expr;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.session.engine.program.model.Expression;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExpressionList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExpressionList.builder()}.
 */
@Generated(from = "ExpressionList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableExpressionList implements ExpressionList {
  private final ImmutableList<Expression> expressions;

  private ImmutableExpressionList(
      ImmutableList<Expression> expressions) {
    this.expressions = expressions;
  }

  /**
   * @return The value of the {@code expressions} attribute
   */
  @Override
  public ImmutableList<Expression> getExpressions() {
    return expressions;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExpressionList#getExpressions() expressions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExpressionList withExpressions(Expression... elements) {
    ImmutableList<Expression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableExpressionList(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExpressionList#getExpressions() expressions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of expressions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExpressionList withExpressions(Iterable<? extends Expression> elements) {
    if (this.expressions == elements) return this;
    ImmutableList<Expression> newValue = ImmutableList.copyOf(elements);
    return new ImmutableExpressionList(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExpressionList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExpressionList
        && equalTo((ImmutableExpressionList) another);
  }

  private boolean equalTo(ImmutableExpressionList another) {
    return expressions.equals(another.expressions);
  }

  /**
   * Computes a hash code from attributes: {@code expressions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + expressions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExpressionList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ExpressionList")
        .omitNullValues()
        .add("expressions", expressions)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ExpressionList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExpressionList instance
   */
  public static ImmutableExpressionList copyOf(ExpressionList instance) {
    if (instance instanceof ImmutableExpressionList) {
      return (ImmutableExpressionList) instance;
    }
    return ImmutableExpressionList.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExpressionList ImmutableExpressionList}.
   * <pre>
   * ImmutableExpressionList.builder()
   *    .addExpressions|addAllExpressions(io.dialob.session.engine.program.model.Expression) // {@link ExpressionList#getExpressions() expressions} elements
   *    .build();
   * </pre>
   * @return A new ImmutableExpressionList builder
   */
  public static ImmutableExpressionList.Builder builder() {
    return new ImmutableExpressionList.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExpressionList ImmutableExpressionList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExpressionList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<Expression> expressions = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExpressionList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ExpressionList instance) {
      Objects.requireNonNull(instance, "instance");
      addAllExpressions(instance.getExpressions());
      return this;
    }

    /**
     * Adds one element to {@link ExpressionList#getExpressions() expressions} list.
     * @param element A expressions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExpressions(Expression element) {
      this.expressions.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ExpressionList#getExpressions() expressions} list.
     * @param elements An array of expressions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExpressions(Expression... elements) {
      this.expressions.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ExpressionList#getExpressions() expressions} list.
     * @param elements An iterable of expressions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expressions(Iterable<? extends Expression> elements) {
      this.expressions = ImmutableList.builder();
      return addAllExpressions(elements);
    }

    /**
     * Adds elements to {@link ExpressionList#getExpressions() expressions} list.
     * @param elements An iterable of expressions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExpressions(Iterable<? extends Expression> elements) {
      this.expressions.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExpressionList ImmutableExpressionList}.
     * @return An immutable instance of ExpressionList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExpressionList build() {
      return new ImmutableExpressionList(expressions.build());
    }
  }
}
