/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.aws.elb;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.JWTProcessor;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.security.spring.tenant.ImmutableGroupGrantedAuthority;
import jakarta.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedCredentialsNotFoundException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails;

public class ElbBasedPreAuthenticatedWebAuthenticationDetailsSource
implements AuthenticationDetailsSource<HttpServletRequest, PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails> {
    private final GrantedAuthoritiesMapper grantedAuthoritiesMapper;
    private final JWTProcessor jwtProcessor;
    private String credentialsRequestHeader = "X-Amzn-Oidc-Data";
    private String groupsClaim = "cognito:groups";

    public ElbBasedPreAuthenticatedWebAuthenticationDetailsSource(@NonNull GrantedAuthoritiesMapper grantedAuthoritiesMapper, @NonNull JWTProcessor jwtProcessor) {
        this.grantedAuthoritiesMapper = grantedAuthoritiesMapper;
        this.jwtProcessor = jwtProcessor;
    }

    public PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails buildDetails(HttpServletRequest request) {
        try {
            String accessTokenHeader = request.getHeader(this.credentialsRequestHeader);
            if (StringUtils.isBlank((CharSequence)accessTokenHeader)) {
                return new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(request, Collections.emptyList());
            }
            JWTClaimsSet accesstoken = this.jwtProcessor.process(accessTokenHeader, null);
            Collection<Object> authorities = Collections.emptyList();
            List stringListClaim = accesstoken.getStringListClaim(this.groupsClaim);
            if (stringListClaim != null) {
                authorities = this.grantedAuthoritiesMapper.mapAuthorities(stringListClaim.stream().map(claim -> ImmutableGroupGrantedAuthority.of((String)claim, (String)claim)).toList());
            }
            return new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(request, authorities);
        }
        catch (JOSEException | BadJOSEException | ParseException e) {
            throw new PreAuthenticatedCredentialsNotFoundException("Could not parse token :" + e.getMessage());
        }
    }

    @Generated
    public void setCredentialsRequestHeader(String credentialsRequestHeader) {
        this.credentialsRequestHeader = credentialsRequestHeader;
    }

    @Generated
    public String getCredentialsRequestHeader() {
        return this.credentialsRequestHeader;
    }

    @Generated
    public void setGroupsClaim(String groupsClaim) {
        this.groupsClaim = groupsClaim;
    }

    @Generated
    public String getGroupsClaim() {
        return this.groupsClaim;
    }
}

