/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.aws;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import io.dialob.security.aws.elb.ElbJWKSource;
import io.dialob.settings.DialobSettings;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration(proxyBeanMethods=false)
@Profile(value={"aws"})
public class DialobSecurityAwsAutoConfiguration {
    @Bean
    public <C extends SecurityContext> JWTProcessor<C> awsElbJwtProcessor(DialobSettings settings, Optional<JWKSource<C>> jwkSource) {
        JWKSource keySource = jwkSource.orElseGet(() -> {
            String url = "https://public-keys.auth.elb." + settings.getAws().getRegion() + ".amazonaws.com/{kid}";
            DefaultResourceRetriever resourceRetriever = new DefaultResourceRetriever(5000, 5000);
            return new ElbJWKSource(url, (ResourceRetriever)resourceRetriever);
        });
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(settings.getAws().getElb().getAlgorithms().stream().map(JWSAlgorithm::parse).collect(Collectors.toSet()), keySource);
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
        return jwtProcessor;
    }
}

