/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.aws.elb;

import com.nimbusds.jwt.proc.JWTProcessor;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.security.aws.elb.ElbBasedPreAuthenticatedWebAuthenticationDetailsSource;
import io.dialob.security.spring.AuthenticationStrategy;
import jakarta.servlet.Filter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.web.authentication.preauth.RequestHeaderAuthenticationFilter;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;

public class ElbAuthenticationStrategy
implements AuthenticationStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ElbAuthenticationStrategy.class);
    private final GrantedAuthoritiesMapper grantedAuthoritiesMapper;
    private final JWTProcessor jwtProcessor;
    private final AuthenticationManager authenticationManager;
    private String credentialsRequestHeader = "X-Amzn-Oidc-Data";
    private String principalRequestHeader = "X-Amzn-Oidc-Identity";
    private String groupsClaim = "cognito:groups";

    public ElbAuthenticationStrategy(@NonNull GrantedAuthoritiesMapper grantedAuthoritiesMapper, @NonNull JWTProcessor jwtProcessor, AuthenticationManager authenticationManager) {
        this.grantedAuthoritiesMapper = grantedAuthoritiesMapper;
        this.jwtProcessor = jwtProcessor;
        this.authenticationManager = authenticationManager;
    }

    public HttpSecurity configureAuthentication(@NonNull HttpSecurity http) throws Exception {
        RequestHeaderAuthenticationFilter filter = this.createAuthenticationFilter(this.authenticationManager);
        http.addFilter((Filter)filter);
        return (HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and();
    }

    @NonNull
    RequestHeaderAuthenticationFilter createAuthenticationFilter(@NonNull AuthenticationManager authenticationManager) {
        RequestHeaderAuthenticationFilter filter = new RequestHeaderAuthenticationFilter();
        HttpSessionSecurityContextRepository securityContextRepository = new HttpSessionSecurityContextRepository();
        securityContextRepository.setAllowSessionCreation(false);
        filter.setSecurityContextRepository((SecurityContextRepository)securityContextRepository);
        LOGGER.debug("principalRequestHeader = {}, credentialsRequestHeader = {}", (Object)this.principalRequestHeader, (Object)this.credentialsRequestHeader);
        filter.setPrincipalRequestHeader(this.principalRequestHeader);
        filter.setCredentialsRequestHeader(this.credentialsRequestHeader);
        filter.setAuthenticationManager(authenticationManager);
        filter.setExceptionIfHeaderMissing(false);
        filter.setContinueFilterChainOnUnsuccessfulAuthentication(false);
        filter.setAuthenticationDetailsSource((AuthenticationDetailsSource)this.createAuthenticationDetailsSource());
        filter.setCheckForPrincipalChanges(false);
        return filter;
    }

    GrantedAuthoritiesMapper getGrantedAuthoritiesMapper() {
        return this.grantedAuthoritiesMapper;
    }

    JWTProcessor getJwtProcessor() {
        return this.jwtProcessor;
    }

    @NonNull
    ElbBasedPreAuthenticatedWebAuthenticationDetailsSource createAuthenticationDetailsSource() {
        ElbBasedPreAuthenticatedWebAuthenticationDetailsSource elbBasedPreAuthenticatedWebAuthenticationDetailsSource = new ElbBasedPreAuthenticatedWebAuthenticationDetailsSource(this.getGrantedAuthoritiesMapper(), this.getJwtProcessor());
        elbBasedPreAuthenticatedWebAuthenticationDetailsSource.setCredentialsRequestHeader(this.credentialsRequestHeader);
        elbBasedPreAuthenticatedWebAuthenticationDetailsSource.setGroupsClaim(this.groupsClaim);
        return elbBasedPreAuthenticatedWebAuthenticationDetailsSource;
    }

    @Generated
    public String getCredentialsRequestHeader() {
        return this.credentialsRequestHeader;
    }

    @Generated
    public void setCredentialsRequestHeader(String credentialsRequestHeader) {
        this.credentialsRequestHeader = credentialsRequestHeader;
    }

    @Generated
    public String getPrincipalRequestHeader() {
        return this.principalRequestHeader;
    }

    @Generated
    public void setPrincipalRequestHeader(String principalRequestHeader) {
        this.principalRequestHeader = principalRequestHeader;
    }

    @Generated
    public void setGroupsClaim(String groupsClaim) {
        this.groupsClaim = groupsClaim;
    }

    @Generated
    public String getGroupsClaim() {
        return this.groupsClaim;
    }
}

