package io.dialob.integration.api.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.security.tenant.Tenant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FormUpdatedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormUpdatedEvent.builder()}.
 */
@Generated(from = "FormUpdatedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableFormUpdatedEvent implements FormUpdatedEvent {
  private final Tenant tenant;
  private final String formId;
  private final String source;
  private final String revision;

  private ImmutableFormUpdatedEvent(
      Tenant tenant,
      String formId,
      String source,
      String revision) {
    this.tenant = tenant;
    this.formId = formId;
    this.source = source;
    this.revision = revision;
  }

  /**
   * @return The value of the {@code tenant} attribute
   */
  @JsonProperty("tenant")
  @Override
  public Tenant getTenant() {
    return tenant;
  }

  /**
   * @return The value of the {@code formId} attribute
   */
  @JsonProperty("formId")
  @Override
  public String getFormId() {
    return formId;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("source")
  @Override
  public String getSource() {
    return source;
  }

  /**
   * @return The value of the {@code revision} attribute
   */
  @JsonProperty("revision")
  @Override
  public String getRevision() {
    return revision;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormUpdatedEvent#getTenant() tenant} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenant
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormUpdatedEvent withTenant(Tenant value) {
    if (this.tenant == value) return this;
    Tenant newValue = Objects.requireNonNull(value, "tenant");
    return new ImmutableFormUpdatedEvent(newValue, this.formId, this.source, this.revision);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormUpdatedEvent#getFormId() formId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormUpdatedEvent withFormId(String value) {
    String newValue = Objects.requireNonNull(value, "formId");
    if (this.formId.equals(newValue)) return this;
    return new ImmutableFormUpdatedEvent(this.tenant, newValue, this.source, this.revision);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormUpdatedEvent#getSource() source} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormUpdatedEvent withSource(String value) {
    String newValue = Objects.requireNonNull(value, "source");
    if (this.source.equals(newValue)) return this;
    return new ImmutableFormUpdatedEvent(this.tenant, this.formId, newValue, this.revision);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormUpdatedEvent#getRevision() revision} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for revision
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormUpdatedEvent withRevision(String value) {
    String newValue = Objects.requireNonNull(value, "revision");
    if (this.revision.equals(newValue)) return this;
    return new ImmutableFormUpdatedEvent(this.tenant, this.formId, this.source, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormUpdatedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormUpdatedEvent
        && equalTo(0, (ImmutableFormUpdatedEvent) another);
  }

  private boolean equalTo(int synthetic, ImmutableFormUpdatedEvent another) {
    return tenant.equals(another.tenant)
        && formId.equals(another.formId)
        && source.equals(another.source)
        && revision.equals(another.revision);
  }

  /**
   * Computes a hash code from attributes: {@code tenant}, {@code formId}, {@code source}, {@code revision}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + tenant.hashCode();
    h += (h << 5) + formId.hashCode();
    h += (h << 5) + source.hashCode();
    h += (h << 5) + revision.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormUpdatedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FormUpdatedEvent{"
        + "tenant=" + tenant
        + ", formId=" + formId
        + ", source=" + source
        + ", revision=" + revision
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FormUpdatedEvent", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FormUpdatedEvent {
    @Nullable Tenant tenant;
    @Nullable String formId;
    @Nullable String source;
    @Nullable String revision;
    @JsonProperty("tenant")
    public void setTenant(Tenant tenant) {
      this.tenant = tenant;
    }
    @JsonProperty("formId")
    public void setFormId(String formId) {
      this.formId = formId;
    }
    @JsonProperty("source")
    public void setSource(String source) {
      this.source = source;
    }
    @JsonProperty("revision")
    public void setRevision(String revision) {
      this.revision = revision;
    }
    @Override
    public Tenant getTenant() { throw new UnsupportedOperationException(); }
    @Override
    public String getFormId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSource() { throw new UnsupportedOperationException(); }
    @Override
    public String getRevision() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormUpdatedEvent fromJson(Json json) {
    ImmutableFormUpdatedEvent.Builder builder = ImmutableFormUpdatedEvent.builder();
    if (json.tenant != null) {
      builder.tenant(json.tenant);
    }
    if (json.formId != null) {
      builder.formId(json.formId);
    }
    if (json.source != null) {
      builder.source(json.source);
    }
    if (json.revision != null) {
      builder.revision(json.revision);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FormUpdatedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormUpdatedEvent instance
   */
  public static ImmutableFormUpdatedEvent copyOf(FormUpdatedEvent instance) {
    if (instance instanceof ImmutableFormUpdatedEvent) {
      return (ImmutableFormUpdatedEvent) instance;
    }
    return ImmutableFormUpdatedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormUpdatedEvent ImmutableFormUpdatedEvent}.
   * <pre>
   * ImmutableFormUpdatedEvent.builder()
   *    .tenant(io.dialob.security.tenant.Tenant) // required {@link FormUpdatedEvent#getTenant() tenant}
   *    .formId(String) // required {@link FormUpdatedEvent#getFormId() formId}
   *    .source(String) // required {@link FormUpdatedEvent#getSource() source}
   *    .revision(String) // required {@link FormUpdatedEvent#getRevision() revision}
   *    .build();
   * </pre>
   * @return A new ImmutableFormUpdatedEvent builder
   */
  public static ImmutableFormUpdatedEvent.Builder builder() {
    return new ImmutableFormUpdatedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormUpdatedEvent ImmutableFormUpdatedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FormUpdatedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TENANT = 0x1L;
    private static final long INIT_BIT_FORM_ID = 0x2L;
    private static final long INIT_BIT_SOURCE = 0x4L;
    private static final long INIT_BIT_REVISION = 0x8L;
    private long initBits = 0xfL;

    private @Nullable Tenant tenant;
    private @Nullable String formId;
    private @Nullable String source;
    private @Nullable String revision;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.TenantScopedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantScopedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.DistributedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DistributedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.FormUpdatedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FormUpdatedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.FormEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FormEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof TenantScopedEvent) {
        TenantScopedEvent instance = (TenantScopedEvent) object;
        if ((bits & 0x4L) == 0) {
          this.tenant(instance.getTenant());
          bits |= 0x4L;
        }
      }
      if (object instanceof DistributedEvent) {
        DistributedEvent instance = (DistributedEvent) object;
        if ((bits & 0x2L) == 0) {
          this.source(instance.getSource());
          bits |= 0x2L;
        }
      }
      if (object instanceof FormUpdatedEvent) {
        FormUpdatedEvent instance = (FormUpdatedEvent) object;
        if ((bits & 0x1L) == 0) {
          this.formId(instance.getFormId());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          this.source(instance.getSource());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          this.tenant(instance.getTenant());
          bits |= 0x4L;
        }
        this.revision(instance.getRevision());
      }
      if (object instanceof FormEvent) {
        FormEvent instance = (FormEvent) object;
        if ((bits & 0x1L) == 0) {
          this.formId(instance.getFormId());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          this.tenant(instance.getTenant());
          bits |= 0x4L;
        }
      }
    }

    /**
     * Initializes the value for the {@link FormUpdatedEvent#getTenant() tenant} attribute.
     * @param tenant The value for tenant 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tenant")
    public final Builder tenant(Tenant tenant) {
      this.tenant = Objects.requireNonNull(tenant, "tenant");
      initBits &= ~INIT_BIT_TENANT;
      return this;
    }

    /**
     * Initializes the value for the {@link FormUpdatedEvent#getFormId() formId} attribute.
     * @param formId The value for formId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("formId")
    public final Builder formId(String formId) {
      this.formId = Objects.requireNonNull(formId, "formId");
      initBits &= ~INIT_BIT_FORM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link FormUpdatedEvent#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("source")
    public final Builder source(String source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link FormUpdatedEvent#getRevision() revision} attribute.
     * @param revision The value for revision 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("revision")
    public final Builder revision(String revision) {
      this.revision = Objects.requireNonNull(revision, "revision");
      initBits &= ~INIT_BIT_REVISION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormUpdatedEvent ImmutableFormUpdatedEvent}.
     * @return An immutable instance of FormUpdatedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormUpdatedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormUpdatedEvent(tenant, formId, source, revision);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TENANT) != 0) attributes.add("tenant");
      if ((initBits & INIT_BIT_FORM_ID) != 0) attributes.add("formId");
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_REVISION) != 0) attributes.add("revision");
      return "Cannot build FormUpdatedEvent, some of required attributes are not set " + attributes;
    }
  }
}
