package io.dialob.integration.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NodeId}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNodeId.builder()}.
 */
@Generated(from = "NodeId", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableNodeId implements NodeId {
  private final String id;
  private final String host;
  private final int port;

  private ImmutableNodeId(String id, String host, int port) {
    this.id = id;
    this.host = host;
    this.port = port;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code host} attribute
   */
  @JsonProperty("host")
  @Override
  public String getHost() {
    return host;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @JsonProperty("port")
  @Override
  public int getPort() {
    return port;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NodeId#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNodeId withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableNodeId(newValue, this.host, this.port);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NodeId#getHost() host} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for host
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNodeId withHost(String value) {
    String newValue = Objects.requireNonNull(value, "host");
    if (this.host.equals(newValue)) return this;
    return new ImmutableNodeId(this.id, newValue, this.port);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NodeId#getPort() port} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNodeId withPort(int value) {
    if (this.port == value) return this;
    return new ImmutableNodeId(this.id, this.host, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNodeId} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNodeId
        && equalTo(0, (ImmutableNodeId) another);
  }

  private boolean equalTo(int synthetic, ImmutableNodeId another) {
    return id.equals(another.id)
        && host.equals(another.host)
        && port == another.port;
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code host}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + host.hashCode();
    h += (h << 5) + port;
    return h;
  }

  /**
   * Prints the immutable value {@code NodeId} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NodeId{"
        + "id=" + id
        + ", host=" + host
        + ", port=" + port
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "NodeId", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements NodeId {
    @Nullable String id;
    @Nullable String host;
    int port;
    boolean portIsSet;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("host")
    public void setHost(String host) {
      this.host = host;
    }
    @JsonProperty("port")
    public void setPort(int port) {
      this.port = port;
      this.portIsSet = true;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getHost() { throw new UnsupportedOperationException(); }
    @Override
    public int getPort() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableNodeId fromJson(Json json) {
    ImmutableNodeId.Builder builder = ImmutableNodeId.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.host != null) {
      builder.host(json.host);
    }
    if (json.portIsSet) {
      builder.port(json.port);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link NodeId} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NodeId instance
   */
  public static ImmutableNodeId copyOf(NodeId instance) {
    if (instance instanceof ImmutableNodeId) {
      return (ImmutableNodeId) instance;
    }
    return ImmutableNodeId.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNodeId ImmutableNodeId}.
   * <pre>
   * ImmutableNodeId.builder()
   *    .id(String) // required {@link NodeId#getId() id}
   *    .host(String) // required {@link NodeId#getHost() host}
   *    .port(int) // required {@link NodeId#getPort() port}
   *    .build();
   * </pre>
   * @return A new ImmutableNodeId builder
   */
  public static ImmutableNodeId.Builder builder() {
    return new ImmutableNodeId.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNodeId ImmutableNodeId}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NodeId", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_HOST = 0x2L;
    private static final long INIT_BIT_PORT = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable String host;
    private int port;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NodeId} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(NodeId instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      this.host(instance.getHost());
      this.port(instance.getPort());
      return this;
    }

    /**
     * Initializes the value for the {@link NodeId#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link NodeId#getHost() host} attribute.
     * @param host The value for host 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("host")
    public final Builder host(String host) {
      this.host = Objects.requireNonNull(host, "host");
      initBits &= ~INIT_BIT_HOST;
      return this;
    }

    /**
     * Initializes the value for the {@link NodeId#getPort() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("port")
    public final Builder port(int port) {
      this.port = port;
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNodeId ImmutableNodeId}.
     * @return An immutable instance of NodeId
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNodeId build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNodeId(id, host, port);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_HOST) != 0) attributes.add("host");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      return "Cannot build NodeId, some of required attributes are not set " + attributes;
    }
  }
}
