/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.integration.api.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.integration.api.event.DistributedEvent;
import io.dialob.integration.api.event.Event;
import io.dialob.integration.api.event.FormEvent;
import io.dialob.integration.api.event.FormTaggedEvent;
import io.dialob.integration.api.event.TenantScopedEvent;
import io.dialob.security.tenant.Tenant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FormTaggedEvent", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableFormTaggedEvent
implements FormTaggedEvent {
    private final Tenant tenant;
    private final String formId;
    private final String source;
    private final String formName;
    private final String tagName;
    @Nullable
    private final String refName;

    private ImmutableFormTaggedEvent(Tenant tenant, String formId, String source, String formName, String tagName, @Nullable String refName) {
        this.tenant = tenant;
        this.formId = formId;
        this.source = source;
        this.formName = formName;
        this.tagName = tagName;
        this.refName = refName;
    }

    @Override
    @JsonProperty(value="tenant")
    public Tenant getTenant() {
        return this.tenant;
    }

    @Override
    @JsonProperty(value="formId")
    public String getFormId() {
        return this.formId;
    }

    @Override
    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @Override
    @JsonProperty(value="formName")
    public String getFormName() {
        return this.formName;
    }

    @Override
    @JsonProperty(value="tagName")
    public String getTagName() {
        return this.tagName;
    }

    @Override
    @JsonProperty(value="refName")
    @Nullable
    public String getRefName() {
        return this.refName;
    }

    public final ImmutableFormTaggedEvent withTenant(Tenant value) {
        if (this.tenant == value) {
            return this;
        }
        Tenant newValue = Objects.requireNonNull(value, "tenant");
        return new ImmutableFormTaggedEvent(newValue, this.formId, this.source, this.formName, this.tagName, this.refName);
    }

    public final ImmutableFormTaggedEvent withFormId(String value) {
        String newValue = Objects.requireNonNull(value, "formId");
        if (this.formId.equals(newValue)) {
            return this;
        }
        return new ImmutableFormTaggedEvent(this.tenant, newValue, this.source, this.formName, this.tagName, this.refName);
    }

    public final ImmutableFormTaggedEvent withSource(String value) {
        String newValue = Objects.requireNonNull(value, "source");
        if (this.source.equals(newValue)) {
            return this;
        }
        return new ImmutableFormTaggedEvent(this.tenant, this.formId, newValue, this.formName, this.tagName, this.refName);
    }

    public final ImmutableFormTaggedEvent withFormName(String value) {
        String newValue = Objects.requireNonNull(value, "formName");
        if (this.formName.equals(newValue)) {
            return this;
        }
        return new ImmutableFormTaggedEvent(this.tenant, this.formId, this.source, newValue, this.tagName, this.refName);
    }

    public final ImmutableFormTaggedEvent withTagName(String value) {
        String newValue = Objects.requireNonNull(value, "tagName");
        if (this.tagName.equals(newValue)) {
            return this;
        }
        return new ImmutableFormTaggedEvent(this.tenant, this.formId, this.source, this.formName, newValue, this.refName);
    }

    public final ImmutableFormTaggedEvent withRefName(@Nullable String value) {
        if (Objects.equals(this.refName, value)) {
            return this;
        }
        return new ImmutableFormTaggedEvent(this.tenant, this.formId, this.source, this.formName, this.tagName, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormTaggedEvent && this.equalTo(0, (ImmutableFormTaggedEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableFormTaggedEvent another) {
        return this.tenant.equals(another.tenant) && this.formId.equals(another.formId) && this.source.equals(another.source) && this.formName.equals(another.formName) && this.tagName.equals(another.tagName) && Objects.equals(this.refName, another.refName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tenant.hashCode();
        h += (h << 5) + this.formId.hashCode();
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.formName.hashCode();
        h += (h << 5) + this.tagName.hashCode();
        h += (h << 5) + Objects.hashCode(this.refName);
        return h;
    }

    public String toString() {
        return "FormTaggedEvent{tenant=" + this.tenant + ", formId=" + this.formId + ", source=" + this.source + ", formName=" + this.formName + ", tagName=" + this.tagName + ", refName=" + this.refName + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormTaggedEvent fromJson(Json json) {
        Builder builder = ImmutableFormTaggedEvent.builder();
        if (json.tenant != null) {
            builder.tenant(json.tenant);
        }
        if (json.formId != null) {
            builder.formId(json.formId);
        }
        if (json.source != null) {
            builder.source(json.source);
        }
        if (json.formName != null) {
            builder.formName(json.formName);
        }
        if (json.tagName != null) {
            builder.tagName(json.tagName);
        }
        if (json.refName != null) {
            builder.refName(json.refName);
        }
        return builder.build();
    }

    public static ImmutableFormTaggedEvent copyOf(FormTaggedEvent instance) {
        if (instance instanceof ImmutableFormTaggedEvent) {
            return (ImmutableFormTaggedEvent)instance;
        }
        return ImmutableFormTaggedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FormTaggedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TENANT = 1L;
        private static final long INIT_BIT_FORM_ID = 2L;
        private static final long INIT_BIT_SOURCE = 4L;
        private static final long INIT_BIT_FORM_NAME = 8L;
        private static final long INIT_BIT_TAG_NAME = 16L;
        private long initBits = 31L;
        @javax.annotation.Nullable
        private Tenant tenant;
        @javax.annotation.Nullable
        private String formId;
        @javax.annotation.Nullable
        private String source;
        @javax.annotation.Nullable
        private String formName;
        @javax.annotation.Nullable
        private String tagName;
        @javax.annotation.Nullable
        private String refName;

        private Builder() {
        }

        public final Builder from(TenantScopedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(FormTaggedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(DistributedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(FormEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Event instance;
            long bits = 0L;
            if (object instanceof TenantScopedEvent) {
                instance = (TenantScopedEvent)object;
                if ((bits & 4L) == 0L) {
                    this.tenant(instance.getTenant());
                    bits |= 4L;
                }
            }
            if (object instanceof FormTaggedEvent) {
                instance = (FormTaggedEvent)object;
                if ((bits & 1L) == 0L) {
                    this.formId(instance.getFormId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.source(instance.getSource());
                    bits |= 2L;
                }
                this.tagName(instance.getTagName());
                String refNameValue = instance.getRefName();
                if (refNameValue != null) {
                    this.refName(refNameValue);
                }
                if ((bits & 4L) == 0L) {
                    this.tenant(instance.getTenant());
                    bits |= 4L;
                }
                this.formName(instance.getFormName());
            }
            if (object instanceof DistributedEvent) {
                instance = (DistributedEvent)object;
                if ((bits & 2L) == 0L) {
                    this.source(instance.getSource());
                    bits |= 2L;
                }
            }
            if (object instanceof FormEvent) {
                instance = (FormEvent)object;
                if ((bits & 1L) == 0L) {
                    this.formId(instance.getFormId());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.tenant(instance.getTenant());
                    bits |= 4L;
                }
            }
        }

        @JsonProperty(value="tenant")
        public final Builder tenant(Tenant tenant) {
            this.tenant = Objects.requireNonNull(tenant, "tenant");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="formId")
        public final Builder formId(String formId) {
            this.formId = Objects.requireNonNull(formId, "formId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="source")
        public final Builder source(String source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="formName")
        public final Builder formName(String formName) {
            this.formName = Objects.requireNonNull(formName, "formName");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="tagName")
        public final Builder tagName(String tagName) {
            this.tagName = Objects.requireNonNull(tagName, "tagName");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="refName")
        public final Builder refName(@Nullable String refName) {
            this.refName = refName;
            return this;
        }

        public ImmutableFormTaggedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormTaggedEvent(this.tenant, this.formId, this.source, this.formName, this.tagName, this.refName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tenant");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("formId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("formName");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("tagName");
            }
            return "Cannot build FormTaggedEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FormTaggedEvent", generator="Immutables")
    static final class Json
    implements FormTaggedEvent {
        @javax.annotation.Nullable
        Tenant tenant;
        @javax.annotation.Nullable
        String formId;
        @javax.annotation.Nullable
        String source;
        @javax.annotation.Nullable
        String formName;
        @javax.annotation.Nullable
        String tagName;
        @javax.annotation.Nullable
        String refName;

        Json() {
        }

        @JsonProperty(value="tenant")
        public void setTenant(Tenant tenant) {
            this.tenant = tenant;
        }

        @JsonProperty(value="formId")
        public void setFormId(String formId) {
            this.formId = formId;
        }

        @JsonProperty(value="source")
        public void setSource(String source) {
            this.source = source;
        }

        @JsonProperty(value="formName")
        public void setFormName(String formName) {
            this.formName = formName;
        }

        @JsonProperty(value="tagName")
        public void setTagName(String tagName) {
            this.tagName = tagName;
        }

        @JsonProperty(value="refName")
        public void setRefName(@Nullable String refName) {
            this.refName = refName;
        }

        @Override
        public Tenant getTenant() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFormId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFormName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTagName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRefName() {
            throw new UnsupportedOperationException();
        }
    }
}

