package io.dialob.integration.api.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dialob.security.tenant.Tenant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FormDeletedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormDeletedEvent.builder()}.
 */
@Generated(from = "FormDeletedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableFormDeletedEvent implements FormDeletedEvent {
  private final Tenant tenant;
  private final String formId;
  private final String source;

  private ImmutableFormDeletedEvent(Tenant tenant, String formId, String source) {
    this.tenant = tenant;
    this.formId = formId;
    this.source = source;
  }

  /**
   * @return The value of the {@code tenant} attribute
   */
  @JsonProperty("tenant")
  @Override
  public Tenant getTenant() {
    return tenant;
  }

  /**
   * @return The value of the {@code formId} attribute
   */
  @JsonProperty("formId")
  @Override
  public String getFormId() {
    return formId;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("source")
  @Override
  public String getSource() {
    return source;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormDeletedEvent#getTenant() tenant} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenant
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormDeletedEvent withTenant(Tenant value) {
    if (this.tenant == value) return this;
    Tenant newValue = Objects.requireNonNull(value, "tenant");
    return new ImmutableFormDeletedEvent(newValue, this.formId, this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormDeletedEvent#getFormId() formId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormDeletedEvent withFormId(String value) {
    String newValue = Objects.requireNonNull(value, "formId");
    if (this.formId.equals(newValue)) return this;
    return new ImmutableFormDeletedEvent(this.tenant, newValue, this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormDeletedEvent#getSource() source} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormDeletedEvent withSource(String value) {
    String newValue = Objects.requireNonNull(value, "source");
    if (this.source.equals(newValue)) return this;
    return new ImmutableFormDeletedEvent(this.tenant, this.formId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormDeletedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormDeletedEvent
        && equalTo(0, (ImmutableFormDeletedEvent) another);
  }

  private boolean equalTo(int synthetic, ImmutableFormDeletedEvent another) {
    return tenant.equals(another.tenant)
        && formId.equals(another.formId)
        && source.equals(another.source);
  }

  /**
   * Computes a hash code from attributes: {@code tenant}, {@code formId}, {@code source}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + tenant.hashCode();
    h += (h << 5) + formId.hashCode();
    h += (h << 5) + source.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormDeletedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FormDeletedEvent{"
        + "tenant=" + tenant
        + ", formId=" + formId
        + ", source=" + source
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FormDeletedEvent", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FormDeletedEvent {
    @Nullable Tenant tenant;
    @Nullable String formId;
    @Nullable String source;
    @JsonProperty("tenant")
    public void setTenant(Tenant tenant) {
      this.tenant = tenant;
    }
    @JsonProperty("formId")
    public void setFormId(String formId) {
      this.formId = formId;
    }
    @JsonProperty("source")
    public void setSource(String source) {
      this.source = source;
    }
    @Override
    public Tenant getTenant() { throw new UnsupportedOperationException(); }
    @Override
    public String getFormId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSource() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormDeletedEvent fromJson(Json json) {
    ImmutableFormDeletedEvent.Builder builder = ImmutableFormDeletedEvent.builder();
    if (json.tenant != null) {
      builder.tenant(json.tenant);
    }
    if (json.formId != null) {
      builder.formId(json.formId);
    }
    if (json.source != null) {
      builder.source(json.source);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FormDeletedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormDeletedEvent instance
   */
  public static ImmutableFormDeletedEvent copyOf(FormDeletedEvent instance) {
    if (instance instanceof ImmutableFormDeletedEvent) {
      return (ImmutableFormDeletedEvent) instance;
    }
    return ImmutableFormDeletedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormDeletedEvent ImmutableFormDeletedEvent}.
   * <pre>
   * ImmutableFormDeletedEvent.builder()
   *    .tenant(io.dialob.security.tenant.Tenant) // required {@link FormDeletedEvent#getTenant() tenant}
   *    .formId(String) // required {@link FormDeletedEvent#getFormId() formId}
   *    .source(String) // required {@link FormDeletedEvent#getSource() source}
   *    .build();
   * </pre>
   * @return A new ImmutableFormDeletedEvent builder
   */
  public static ImmutableFormDeletedEvent.Builder builder() {
    return new ImmutableFormDeletedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormDeletedEvent ImmutableFormDeletedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FormDeletedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TENANT = 0x1L;
    private static final long INIT_BIT_FORM_ID = 0x2L;
    private static final long INIT_BIT_SOURCE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Tenant tenant;
    private @Nullable String formId;
    private @Nullable String source;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.TenantScopedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantScopedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.FormDeletedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FormDeletedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.DistributedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DistributedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.integration.api.event.FormEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FormEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof TenantScopedEvent) {
        TenantScopedEvent instance = (TenantScopedEvent) object;
        if ((bits & 0x4L) == 0) {
          this.tenant(instance.getTenant());
          bits |= 0x4L;
        }
      }
      if (object instanceof FormDeletedEvent) {
        FormDeletedEvent instance = (FormDeletedEvent) object;
        if ((bits & 0x1L) == 0) {
          this.formId(instance.getFormId());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          this.tenant(instance.getTenant());
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          this.source(instance.getSource());
          bits |= 0x2L;
        }
      }
      if (object instanceof DistributedEvent) {
        DistributedEvent instance = (DistributedEvent) object;
        if ((bits & 0x2L) == 0) {
          this.source(instance.getSource());
          bits |= 0x2L;
        }
      }
      if (object instanceof FormEvent) {
        FormEvent instance = (FormEvent) object;
        if ((bits & 0x1L) == 0) {
          this.formId(instance.getFormId());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          this.tenant(instance.getTenant());
          bits |= 0x4L;
        }
      }
    }

    /**
     * Initializes the value for the {@link FormDeletedEvent#getTenant() tenant} attribute.
     * @param tenant The value for tenant 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tenant")
    public final Builder tenant(Tenant tenant) {
      this.tenant = Objects.requireNonNull(tenant, "tenant");
      initBits &= ~INIT_BIT_TENANT;
      return this;
    }

    /**
     * Initializes the value for the {@link FormDeletedEvent#getFormId() formId} attribute.
     * @param formId The value for formId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("formId")
    public final Builder formId(String formId) {
      this.formId = Objects.requireNonNull(formId, "formId");
      initBits &= ~INIT_BIT_FORM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link FormDeletedEvent#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("source")
    public final Builder source(String source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormDeletedEvent ImmutableFormDeletedEvent}.
     * @return An immutable instance of FormDeletedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormDeletedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormDeletedEvent(tenant, formId, source);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TENANT) != 0) attributes.add("tenant");
      if ((initBits & INIT_BIT_FORM_ID) != 0) attributes.add("formId");
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      return "Cannot build FormDeletedEvent, some of required attributes are not set " + attributes;
    }
  }
}
