/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.sp;

import io.dialob.db.sp.ConditionalOnDatabaseType;
import io.dialob.settings.DialobSettings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnDatabaseTypeCondition
extends SpringBootCondition {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OnDatabaseTypeCondition.class);

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map allAnnotationAttributes = metadata.getAnnotationAttributes(ConditionalOnDatabaseType.class.getName(), false);
        DialobSettings.DatabaseType databaseType = (DialobSettings.DatabaseType)allAnnotationAttributes.get("value");
        if (databaseType == null) {
            return ConditionOutcome.noMatch((String)"database type not defined");
        }
        HashSet<DialobSettings.DatabaseType> requiredTypes = new HashSet<DialobSettings.DatabaseType>();
        this.addType(context, requiredTypes, "dialob.db.database-type");
        this.addType(context, requiredTypes, "dialob.form-database.database-type");
        this.addType(context, requiredTypes, "dialob.questionnaire-database.database-type");
        if (requiredTypes.contains(databaseType)) {
            return ConditionOutcome.match();
        }
        return ConditionOutcome.noMatch((String)("database type " + databaseType + " not required"));
    }

    public void addType(ConditionContext context, Set<DialobSettings.DatabaseType> requiredTypes, String key) {
        String databaseTypeProperty = null;
        try {
            databaseTypeProperty = context.getEnvironment().getProperty(key);
            if (databaseTypeProperty != null) {
                requiredTypes.add(DialobSettings.DatabaseType.valueOf((String)databaseTypeProperty.trim().toUpperCase()));
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Unknown database type " + key + "=" + databaseTypeProperty + ". Acceptable values are: " + StringUtils.join((Object[])DialobSettings.DatabaseType.values(), (String)","));
        }
    }
}

