/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.dialob.api;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.db.dialob.api.DialobApiTemplate;
import io.dialob.db.spi.spring.AbstractDocumentDatabase;

public abstract class AbstractDialobApiDatabase<T>
extends AbstractDocumentDatabase<T> {
    private final DialobApiTemplate dialobApiTemplate;
    private final String resource;

    public AbstractDialobApiDatabase(DialobApiTemplate dialobApiTemplate, String resource, Class<T> entityClass) {
        super(entityClass);
        this.dialobApiTemplate = dialobApiTemplate;
        this.resource = resource;
    }

    @NonNull
    public T findOne(String tenantId, @NonNull String id, String rev) {
        return this.dialobApiTemplate.findOne(this.resource, id, rev, this.getDocumentClass());
    }

    @NonNull
    public T save(String tenantId, @NonNull T document) {
        return this.dialobApiTemplate.save(this.resource, this.id(document), document);
    }

    @NonNull
    public T findOne(String tenantId, @NonNull String id) {
        return this.findOne(tenantId, id, null);
    }

    public boolean exists(String tenantId, @NonNull String id) {
        throw new UnsupportedOperationException("exists not supported");
    }

    public boolean delete(String tenantId, @NonNull String id) {
        throw new UnsupportedOperationException("delete not supported");
    }
}

