/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.azure.blob.storage;

import com.azure.storage.blob.BlobContainerClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.api.questionnaire.ImmutableQuestionnaire;
import io.dialob.api.questionnaire.ImmutableQuestionnaireMetadata;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.db.azure.blob.storage.AbstractAzureBlobStorageDatabase;
import io.dialob.questionnaire.service.api.ImmutableMetadataRow;
import io.dialob.questionnaire.service.api.QuestionnaireDatabase;
import java.util.Date;
import java.util.Objects;
import java.util.function.Consumer;

public class QuestionnaireAzureBlobStorageDatabase
extends AbstractAzureBlobStorageDatabase<Questionnaire>
implements QuestionnaireDatabase {
    public QuestionnaireAzureBlobStorageDatabase(BlobContainerClient blobContainerClient, ObjectMapper objectMapper, String prefix, String suffix) {
        super(blobContainerClient, Questionnaire.class, objectMapper, Objects.requireNonNullElse(prefix, "questionnaires"), suffix);
    }

    public void findAllMetadata(String tenantId, String ownerId, String formId, String formName, String formTag, Questionnaire.Metadata.Status status, @NonNull Consumer<QuestionnaireDatabase.MetadataRow> consumer) {
        this.forAllObjects(tenantId, object -> {
            String id = this.extractObjectName(object.getName());
            consumer.accept((QuestionnaireDatabase.MetadataRow)ImmutableMetadataRow.of((String)id, (Questionnaire.Metadata)ImmutableQuestionnaireMetadata.builder().lastAnswer(Date.from(object.getProperties().getLastModified().toInstant())).build()));
        });
    }

    @NonNull
    protected Questionnaire updateDocumentId(@NonNull Questionnaire document, String id) {
        return ImmutableQuestionnaire.builder().from(document).id(id).build();
    }

    @NonNull
    protected Questionnaire updateDocumentRev(@NonNull Questionnaire document, String rev) {
        return ImmutableQuestionnaire.builder().from(document).rev(rev).build();
    }
}

