/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.azure.blob.storage;

import com.azure.storage.blob.BlobContainerClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.api.form.Form;
import io.dialob.api.form.ImmutableForm;
import io.dialob.api.form.ImmutableFormMetadata;
import io.dialob.db.azure.blob.storage.AbstractAzureBlobStorageDatabase;
import io.dialob.form.service.api.FormDatabase;
import io.dialob.form.service.api.ImmutableFormMetadataRow;
import java.util.Date;
import java.util.Objects;
import java.util.function.Consumer;

public class FormAzureBlobStorageDatabase
extends AbstractAzureBlobStorageDatabase<Form>
implements FormDatabase {
    public FormAzureBlobStorageDatabase(BlobContainerClient blobContainerClient, ObjectMapper objectMapper, String prefix, String suffix) {
        super(blobContainerClient, Form.class, objectMapper, Objects.requireNonNullElse(prefix, "forms"), suffix);
    }

    public void findAllMetadata(String tenantId, Form.Metadata metadata, @NonNull Consumer<FormDatabase.FormMetadataRow> consumer) {
        this.forAllObjects(tenantId, object -> {
            String id = this.extractObjectName(object.getName());
            consumer.accept((FormDatabase.FormMetadataRow)ImmutableFormMetadataRow.of((String)id, (Form.Metadata)ImmutableFormMetadata.builder().lastSaved(Date.from(object.getProperties().getLastModified().toInstant())).tenantId(tenantId).build()));
        });
    }

    @NonNull
    protected Form updateDocumentId(@NonNull Form form, String id) {
        return ImmutableForm.builder().from(form).id(id).build();
    }

    @NonNull
    protected Form updateDocumentRev(@NonNull Form form, String rev) {
        return ImmutableForm.builder().from(form).rev(rev).build();
    }
}

