/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.db.azure.blob.storage;

import com.azure.core.util.BinaryData;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.dialob.db.azure.blob.storage.VersionConflictException;
import io.dialob.db.spi.exceptions.DocumentCorruptedException;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.db.spi.spring.AbstractDocumentDatabase;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzureBlobStorageDatabase<F>
extends AbstractDocumentDatabase<F> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAzureBlobStorageDatabase.class);
    private final ObjectMapper objectMapper;
    private final BlobContainerClient blobContainerClient;
    private final String prefix;
    private final String suffix;

    public AbstractAzureBlobStorageDatabase(@NonNull BlobContainerClient blobContainerClient, @NonNull Class<F> documentClass, @NonNull ObjectMapper objectMapper, @NonNull String prefix, String suffix) {
        super(documentClass);
        this.blobContainerClient = blobContainerClient;
        this.objectMapper = objectMapper;
        this.prefix = StringUtils.stripEnd((String)StringUtils.stripStart((String)prefix, (String)"/\\\n\r "), (String)"/\\\n\r ");
        this.suffix = Objects.requireNonNullElse(suffix, "");
    }

    protected String tenantPrefix(String tenantId) {
        return this.prefix + "/" + tenantId;
    }

    protected String objectName(String tenantId, String id) {
        return this.tenantPrefix(tenantId) + "/" + id + this.suffix;
    }

    protected String extractObjectName(String key) {
        return key.substring(key.lastIndexOf("/") + 1);
    }

    @NonNull
    public F findOne(@NonNull String tenantId, @NonNull String id, String rev) {
        try {
            String objectName = this.objectName(tenantId, id);
            InputStream blob = this.blobContainerClient.getBlobClient(objectName).downloadContent().toStream();
            return this.loadFile(objectName, blob);
        }
        catch (BlobStorageException e) {
            if (e.getErrorCode() == BlobErrorCode.BLOB_NOT_FOUND) {
                throw new DocumentNotFoundException("No form document \"" + id + "\"");
            }
            throw e;
        }
    }

    public F loadFile(String objectName, InputStream inputStream) {
        try {
            return (F)this.objectMapper.readValue(inputStream, this.getDocumentClass());
        }
        catch (IOException e) {
            LOGGER.error("Object {} is corrupted.", (Object)objectName, (Object)e);
            return null;
        }
    }

    @NonNull
    public F findOne(@NonNull String tenantId, @NonNull String id) {
        return this.findOne(tenantId, id, null);
    }

    protected void forAllObjects(String tenantId, @NonNull Consumer<BlobItem> fileConsumer) {
        this.blobContainerClient.listBlobs(new ListBlobsOptions().setPrefix(this.tenantPrefix(tenantId)).setMaxResultsPerPage(Integer.valueOf(200)), Duration.ofSeconds(20L)).forEach(fileConsumer);
    }

    public boolean exists(@NonNull String tenantId, @NonNull String id) {
        return this.blobContainerClient.getBlobClient(this.objectName(tenantId, id)).exists();
    }

    public boolean delete(String tenantId, @NonNull String id) {
        if (this.exists(tenantId, id)) {
            this.blobContainerClient.getBlobClient(this.objectName(tenantId, id)).delete();
            return true;
        }
        return false;
    }

    @NonNull
    public F save(String tenantId, @NonNull F document) {
        String id = this.id(document);
        String rev = this.rev(document);
        if (!StringUtils.isBlank((CharSequence)id)) {
            try {
                F previousVersion = this.findOne(tenantId, id);
                if (rev == null || !rev.equals(this.rev(previousVersion))) {
                    throw new VersionConflictException(id + " revision " + this.rev(previousVersion) + " do not match with " + rev);
                }
                document = this.updateDocumentRev(document, Integer.toString(Integer.parseInt(rev) + 1));
            }
            catch (DocumentNotFoundException e) {
                document = this.initNewDocument(document);
                id = this.id(document);
            }
        } else {
            document = this.initNewDocument(document);
            id = this.id(document);
        }
        try {
            BlobClient blob = this.blobContainerClient.getBlobClient(this.objectName(tenantId, id));
            blob.upload(BinaryData.fromBytes((byte[])this.objectMapper.writeValueAsBytes(document)), true);
            blob.setHttpHeaders(new BlobHttpHeaders().setContentType("application/json"));
        }
        catch (BlobStorageException | JsonProcessingException e) {
            LOGGER.error("Failed to write document {}", (Object)id, (Object)e);
            throw new DocumentCorruptedException("Cannot update document " + id);
        }
        return document;
    }

    private F initNewDocument(F document) {
        document = this.updateDocumentId(document, this.createUuid());
        document = this.updateDocumentRev(document, "1");
        return document;
    }

    protected String createUuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}

