/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.api.form.Form;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.boot.controller.BaseController;
import io.dialob.boot.controller.PageAttributes;
import io.dialob.boot.controller.PageSettingsProvider;
import io.dialob.boot.controller.ReviewController;
import io.dialob.boot.settings.ReviewApplicationSettings;
import io.dialob.form.service.api.FormDatabase;
import io.dialob.questionnaire.service.api.QuestionnaireDatabase;
import io.dialob.security.tenant.CurrentTenant;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${review.context-path:/review}"})
public class ReviewController
extends BaseController {
    private final CurrentTenant currentTenant;
    private ReviewApplicationSettings settings;
    private QuestionnaireDatabase questionnaireRepository;
    private FormDatabase formDatabase;
    private ObjectMapper objectMapper;
    private final PageSettingsProvider pageSettingsProvider;

    public ReviewController(ReviewApplicationSettings settings, QuestionnaireDatabase questionnaireRepository, FormDatabase formDatabase, ObjectMapper objectMapper, CurrentTenant currentTenant, PageSettingsProvider pageSettingsProvider) {
        this.settings = settings;
        this.questionnaireRepository = questionnaireRepository;
        this.formDatabase = formDatabase;
        this.objectMapper = objectMapper;
        this.currentTenant = currentTenant;
        this.pageSettingsProvider = pageSettingsProvider;
    }

    @GetMapping(value={"/{questionnaireId}"}, produces={"text/html"})
    public String review(@RequestHeader(value="X-Forwarded-For", required=false) String forwardedFor, @RequestHeader(value="Host", required=false) String host, @RequestHeader(value="X-Real-IP", required=false) String realIp, @RequestHeader(value="X-Forwarded-Proto", required=false) String forwardedProto, @PathVariable(value="questionnaireId") String questionnaireId, CsrfToken cfrsToken, Model model, HttpServletRequest request) throws JsonProcessingException {
        ReviewOptions reviewOptions = new ReviewOptions();
        reviewOptions.setApiUrl(this.settings.getApiUrl());
        reviewOptions.setQuestionnaireId(questionnaireId);
        reviewOptions.setCsrf(cfrsToken);
        String tenantId = request.getParameter("tenantId");
        if (!StringUtils.isBlank((CharSequence)tenantId)) {
            reviewOptions.setTenantId(tenantId);
        }
        if (StringUtils.isBlank((CharSequence)this.settings.getApiUrl())) {
            Questionnaire questionnaire = this.questionnaireRepository.findOne(this.currentTenant.getId(), questionnaireId);
            String formRev = "LATEST".equals(questionnaire.getMetadata().getFormRev()) ? null : questionnaire.getMetadata().getFormRev();
            Form form = this.formDatabase.findOne(this.currentTenant.getId(), questionnaire.getMetadata().getFormId(), formRev);
            reviewOptions.setForm(this.objectMapper.writeValueAsString((Object)form));
            reviewOptions.setSessionData(this.objectMapper.writeValueAsString((Object)questionnaire));
        }
        model.addAttribute("reviewOptions", (Object)reviewOptions);
        PageAttributes pageAttributes = this.pageSettingsProvider.findPageSettingsByQuestionnaireId("review", questionnaireId);
        model.addAllAttributes(pageAttributes.getAttributes());
        this.index(model, request);
        return pageAttributes.getTemplate();
    }
}

