/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.controller;

import io.dialob.boot.controller.AdminController;
import io.dialob.boot.controller.BaseController;
import io.dialob.boot.controller.PageAttributes;
import io.dialob.boot.controller.PageSettingsProvider;
import io.dialob.boot.settings.AdminApplicationSettings;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${admin.context-path:/}"})
public class AdminController
extends BaseController {
    private final AdminApplicationSettings adminApplicationSettings;
    private final PageSettingsProvider pageSettingsProvider;

    public AdminController(AdminApplicationSettings adminApplicationSettings, PageSettingsProvider pageSettingsProvider) {
        this.adminApplicationSettings = adminApplicationSettings;
        this.pageSettingsProvider = pageSettingsProvider;
    }

    @GetMapping(path={"", "/index.html"}, produces={"text/html"})
    public String index(CsrfToken cfrsToken, Model model, HttpServletRequest request) {
        model.addAttribute("_csrf", (Object)cfrsToken);
        model.addAttribute("adminConfig", (Object)this.getAdminConfig(cfrsToken, request));
        PageAttributes pageAttributes = this.pageSettingsProvider.findPageSettings("admin");
        model.addAllAttributes(pageAttributes.getAttributes());
        this.index(model, request);
        return pageAttributes.getTemplate();
    }

    @GetMapping(path={"/config.json"}, produces={"application/json"})
    @ResponseBody
    public AdminConfig config(CsrfToken cfrsToken, Model model, HttpServletRequest request) {
        return this.getAdminConfig(cfrsToken, request);
    }

    @NonNull
    public AdminConfig getAdminConfig(CsrfToken cfrsToken, HttpServletRequest request) {
        AdminConfig adminConfig = new AdminConfig();
        adminConfig.setCsrf(cfrsToken);
        adminConfig.setUrl(this.adminApplicationSettings.getApiUrl());
        adminConfig.setFillUrl(this.adminApplicationSettings.getFillingAppUrl());
        adminConfig.setReviewUrl(this.adminApplicationSettings.getReviewAppUrl());
        adminConfig.setDocumentation(this.adminApplicationSettings.getDocumentation());
        adminConfig.setComposerUrl(this.adminApplicationSettings.getComposerAppUrl());
        adminConfig.setVersioning(this.adminApplicationSettings.isVersioning());
        String tenantId = request.getParameter("tenantId");
        if (!StringUtils.isBlank((CharSequence)tenantId)) {
            adminConfig.setTenantId(tenantId);
        }
        return adminConfig;
    }
}

