/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot;

import io.dialob.api.rest.ImmutableErrors;
import io.dialob.session.engine.DialobProgramBuildException;
import io.dialob.session.engine.program.ProgramBuilderException;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class DialobProgramExceptionHandlers {
    @ExceptionHandler
    public ResponseEntity handleProgramBuilderException(ProgramBuilderException e) {
        return this.buildResponse(HttpStatus.UNPROCESSABLE_ENTITY, e.getMessage());
    }

    @ExceptionHandler
    public ResponseEntity handleDialobProgramBuildException(DialobProgramBuildException e) {
        return this.buildResponse(HttpStatus.UNPROCESSABLE_ENTITY, e.getMessage());
    }

    private ResponseEntity buildResponse(HttpStatus status, String message) {
        return ResponseEntity.status((HttpStatus)status).contentType(MediaType.APPLICATION_JSON).body((Object)ImmutableErrors.builder().status(Integer.valueOf(status.value())).error(status.getReasonPhrase()).message(message).build());
    }
}

