/*
 * Decompiled with CFR 0.152.
 */
package io.deltastream.flink.connector.snowflake.sink;

import io.deltastream.flink.connector.snowflake.sink.SnowflakeSink;
import io.deltastream.flink.connector.snowflake.sink.SnowflakeSinkBuilder;
import io.deltastream.flink.connector.snowflake.sink.context.SnowflakeSinkContext;
import io.deltastream.flink.connector.snowflake.sink.serialization.SnowflakeRowSerializationSchema;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.shaded.guava31.com.google.common.collect.Maps;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
class SnowflakeSinkITCase {
    private static final String url = SystemUtils.getEnvironmentVariable((String)"SNOWFLAKE_URL", (String)"fake.sf.com:443");
    private static final String user = SystemUtils.getEnvironmentVariable((String)"SNOWFLAKE_USER", (String)"SF_USER");
    private static final String role = SystemUtils.getEnvironmentVariable((String)"SNOWFLAKE_ROLE", (String)"SF_ROLE");
    private static final String key = SystemUtils.getEnvironmentVariable((String)"SNOWFLAKE_PRIVATE_KEY", (String)"");
    private static final String keyPass = SystemUtils.getEnvironmentVariable((String)"SNOWFLAKE_KEY_PASSPHRASE", (String)"");
    @RegisterExtension
    static final MiniClusterExtension MINI_CLUSTER_RESOURCE = new MiniClusterExtension(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).build());

    SnowflakeSinkITCase() {
    }

    @Test
    public void testSuccessfulWriteToSnowflake() throws Exception {
        SnowflakeSinkBuilder sinkBuilder = SnowflakeSink.builder().url(url).user(user).role(role).bufferTimeMillis(2000L).database("FLINK_STREAMING").schema("PUBLIC").table("\"stream_data_tbl\"").serializationSchema((SnowflakeRowSerializationSchema)new RowPassThroughSerializer());
        if (StringUtils.isNotBlank((CharSequence)key)) {
            sinkBuilder.privateKey(key);
        }
        if (StringUtils.isNotBlank((CharSequence)keyPass)) {
            sinkBuilder.keyPassphrase(keyPass);
        }
        SnowflakeSink sink = sinkBuilder.build("sf_sink_job");
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.enableCheckpointing(100L);
        env.setRestartStrategy(RestartStrategies.noRestart());
        env.setParallelism(1);
        env.fromSequence(1L, 10L).map((MapFunction)new SfRowMapFunction()).sinkTo((Sink)sink);
        env.execute();
    }

    private static class RowPassThroughSerializer
    implements SnowflakeRowSerializationSchema<Map<String, Object>> {
        private static final long serialVersionUID = -23875899103249615L;

        private RowPassThroughSerializer() {
        }

        public Map<String, Object> serialize(Map<String, Object> element, SnowflakeSinkContext sinkContext) {
            return element;
        }
    }

    private static class SfRowMapFunction
    implements MapFunction<Long, Map<String, Object>> {
        private static final long serialVersionUID = -2836417330784371895L;

        private SfRowMapFunction() {
        }

        public Map<String, Object> map(Long id) {
            String uuid = UUID.randomUUID().toString();
            return Maps.newHashMap(Map.of("\"id\"", uuid + "-" + id, "\"data\"", uuid + "_" + id));
        }
    }
}

