/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.snowflake.ingest.streaming.InsertValidationResponse;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestChannel;
import net.snowflake.ingest.streaming.internal.ColumnProperties;
import org.testcontainers.shaded.com.google.common.collect.Lists;

public class FakeSnowflakeStreamingIngestChannel
implements SnowflakeStreamingIngestChannel {
    private final String name;
    private final String fullyQualifiedName;
    private final String dbName;
    private final String schemaName;
    private final String tableName;
    private final String fullyQualifiedTableName;
    private boolean closed;
    private String offsetToken;
    private List<Map<String, Object>> rows = new LinkedList<Map<String, Object>>();

    public FakeSnowflakeStreamingIngestChannel(String name, String dbName, String schemaName, String tableName) {
        this.name = name;
        this.dbName = dbName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.fullyQualifiedName = String.format("%s.%s.%s.%s", dbName, schemaName, tableName, name);
        this.fullyQualifiedTableName = String.format("%s.%s.%s", dbName, schemaName, tableName);
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public String getName() {
        return this.name;
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFullyQualifiedTableName() {
        return this.fullyQualifiedTableName;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public CompletableFuture<Void> close() {
        this.closed = true;
        return CompletableFuture.completedFuture(null);
    }

    public InsertValidationResponse insertRow(Map<String, Object> row, String offsetToken) {
        return this.insertRows(Lists.newArrayList((Object[])new Map[]{row}), offsetToken);
    }

    public InsertValidationResponse insertRows(Iterable<Map<String, Object>> rows, String offsetToken) {
        LinkedList rowsCopy = new LinkedList();
        rows.forEach(r -> rowsCopy.add(new LinkedHashMap(r)));
        this.rows.addAll(rowsCopy);
        this.offsetToken = offsetToken;
        return new InsertValidationResponse();
    }

    public String getLatestCommittedOffsetToken() {
        return this.offsetToken;
    }

    public Map<String, ColumnProperties> getTableSchema() {
        throw new UnsupportedOperationException("Method is unsupported in fake communication channel");
    }
}

