/*
 * Decompiled with CFR 0.152.
 */
package io.deltastream.flink.connector.snowflake.sink.internal;

import io.deltastream.flink.connector.snowflake.sink.internal.SnowflakeInternalUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SnowflakeInternalUtilsTest {
    SnowflakeInternalUtilsTest() {
    }

    @Test
    void testCreateClientOrChannelNameWithAllParts() {
        Assertions.assertThat((String)SnowflakeInternalUtils.createClientOrChannelName((String)"prefix", (String)"name", (Integer)0)).isEqualTo("prefix_name_0");
    }

    @Test
    void testCreateClientOrChannelNameWithoutSomeParts() {
        Assertions.assertThat((String)SnowflakeInternalUtils.createClientOrChannelName(null, (String)"name", (Integer)0)).isEqualTo("name_0");
        Assertions.assertThat((String)SnowflakeInternalUtils.createClientOrChannelName((String)"prefix", (String)"", (Integer)0)).isEqualTo("prefix_0");
    }

    @Test
    void testInvalidCreateClientOrChannelNameWithoutPrefixOrName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SnowflakeInternalUtils.createClientOrChannelName(null, null, (Integer)1)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("One of prefix or name must be set");
    }
}

