/*
 * Decompiled with CFR 0.152.
 */
package io.deltastream.flink.connector.snowflake.sink;

import io.deltastream.flink.connector.snowflake.sink.SnowflakeSink;
import io.deltastream.flink.connector.snowflake.sink.SnowflakeSinkBuilder;
import io.deltastream.flink.connector.snowflake.sink.serialization.SnowflakeRowSerializationSchema;
import java.io.Serializable;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SnowflakeSinkBuilderTest {
    SnowflakeSinkBuilderTest() {
    }

    @Test
    public void testConnectionPropsOnBuild() {
        SnowflakeSink sink = SnowflakeSink.builder().url("test-url").user("test-user").role("test-role").database("test_db").schema("test_schema").table("test_table").serializationSchema((SnowflakeRowSerializationSchema & Serializable)(element, sinkContext) -> element).build("build-test");
        Assertions.assertThat((Map)sink.getConnectionConfigs()).containsKeys(new Object[]{"url", "user", "role"});
    }

    @Test
    public void testFailureOnMissingUrlConnectionProperty() {
        Assertions.assertThatThrownBy(() -> SnowflakeSink.builder().user("test-user").role("test-role").checkConnectionProps()).hasMessageContaining("Required connection properties documented by Snowflake");
    }

    @Test
    public void testFailureOnMissingUserConnectionProperty() {
        Assertions.assertThatThrownBy(() -> SnowflakeSink.builder().url("test-url").role("test-role").checkConnectionProps()).hasMessageContaining("Required connection properties documented by Snowflake");
    }

    @Test
    public void testFailureOnMissingRoleConnectionProperty() {
        Assertions.assertThatThrownBy(() -> SnowflakeSink.builder().url("test-url").user("test-user").checkConnectionProps()).hasMessageContaining("Required connection properties documented by Snowflake");
    }

    @Test
    public void testFailureOnInvalidUrlConnectionProperty() {
        Assertions.assertThatThrownBy(() -> SnowflakeSink.builder().url("")).hasMessage("Invalid url");
    }

    @Test
    public void testFailureOnInvalidPrivateKeyConnectionProperty() {
        Assertions.assertThatThrownBy(() -> SnowflakeSink.builder().privateKey("")).hasMessage("Invalid private_key");
    }

    @Test
    public void testFailureOnMissingPrivateKeyWithPassphrase() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SnowflakeSink.builder().url("test-url").user("test-user").role("test-role").keyPassphrase("some-passphrase").checkConnectionProps()).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("%s requires %s", "private_key_passphrase", "private_key"));
    }

    @Test
    public void testFailureOnMissingPrivateKeyWithEmptyPassphrase() {
        SnowflakeSinkBuilder bSink = SnowflakeSink.builder().url("test-url").user("test-user").role("test-role").database("test_db").schema("test_schema").table("test_table").privateKey("some-priv-key").keyPassphrase("").serializationSchema((SnowflakeRowSerializationSchema & Serializable)(element, sinkContext) -> element);
        SnowflakeSink sink = bSink.build("passphrase-test");
        Assertions.assertThat((Object)sink.getConnectionConfigs().get("private_key_passphrase")).isEqualTo((Object)"");
    }
}

