/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.snowflake.ingest.streaming.FakeSnowflakeStreamingIngestChannel;
import net.snowflake.ingest.streaming.OpenChannelRequest;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestChannel;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestClient;

public class FakeSnowflakeStreamingIngestClient
implements SnowflakeStreamingIngestClient {
    private final String name;
    private boolean closed;
    private final ConcurrentHashMap<String, FakeSnowflakeStreamingIngestChannel> channelCache = new ConcurrentHashMap();

    public FakeSnowflakeStreamingIngestClient(String name) {
        this.name = name;
    }

    public SnowflakeStreamingIngestChannel openChannel(OpenChannelRequest request) {
        String fqdn = String.format("%s.%s", request.getFullyQualifiedTableName(), request.getChannelName());
        return this.channelCache.computeIfAbsent(fqdn, key -> new FakeSnowflakeStreamingIngestChannel(this.name, request.getDBName(), request.getSchemaName(), request.getTableName()));
    }

    public String getName() {
        return this.name;
    }

    public void setRefreshToken(String refreshToken) {
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Map<String, String> getLatestCommittedOffsetTokens(List<SnowflakeStreamingIngestChannel> channels) {
        HashMap<String, String> offsetTokens = new HashMap<String, String>();
        channels.forEach(c -> {
            String fqn = c.getFullyQualifiedName();
            String token = this.channelCache.get(fqn).getLatestCommittedOffsetToken();
            offsetTokens.put(fqn, token);
        });
        return offsetTokens;
    }

    public void close() throws Exception {
        this.closed = true;
    }
}

