/*
 * Decompiled with CFR 0.152.
 */
package io.deltastream.flink.connector.snowflake.sink.config;

import io.deltastream.flink.connector.snowflake.sink.config.SnowflakeChannelConfig;
import net.snowflake.ingest.streaming.OpenChannelRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SnowflakeChannelConfigTest {
    private static final String databaseName = "scct_db";
    private static final String schemaName = "scct_schema";
    private static final String tableName = "scct_table";

    SnowflakeChannelConfigTest() {
    }

    @Test
    public void testChannelConfigBuild() {
        SnowflakeChannelConfig sfcc = SnowflakeChannelConfig.builder().onErrorOption(OpenChannelRequest.OnErrorOption.CONTINUE).build(databaseName, schemaName, tableName);
        Assertions.assertEquals((Object)databaseName, (Object)sfcc.getDatabaseName());
        Assertions.assertEquals((Object)schemaName, (Object)sfcc.getSchemaName());
        Assertions.assertEquals((Object)tableName, (Object)sfcc.getTableName());
        Assertions.assertEquals((Object)OpenChannelRequest.OnErrorOption.CONTINUE, (Object)sfcc.getOnErrorOption());
    }

    @Test
    public void testChannelConfigBuildWithDefaultErrorOption() {
        SnowflakeChannelConfig sfcc = SnowflakeChannelConfig.builder().build(databaseName, schemaName, tableName);
        Assertions.assertEquals((Object)OpenChannelRequest.OnErrorOption.ABORT, (Object)sfcc.getOnErrorOption());
    }

    @Test
    public void testInvalidDatabaseName() {
        IllegalArgumentException emptyIae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> SnowflakeChannelConfig.builder().build("", schemaName, tableName));
        Assertions.assertEquals((Object)"Invalid database name", (Object)emptyIae.getMessage());
        IllegalArgumentException nullIae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> SnowflakeChannelConfig.builder().build(null, schemaName, tableName));
        Assertions.assertEquals((Object)"Invalid database name", (Object)nullIae.getMessage());
    }

    @Test
    public void testInvalidSchemaName() {
        IllegalArgumentException emptyIae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> SnowflakeChannelConfig.builder().build(databaseName, "", tableName));
        Assertions.assertEquals((Object)"Invalid schema name", (Object)emptyIae.getMessage());
        IllegalArgumentException nullIae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> SnowflakeChannelConfig.builder().build(databaseName, null, tableName));
        Assertions.assertEquals((Object)"Invalid schema name", (Object)nullIae.getMessage());
    }

    @Test
    public void testInvalidTableName() {
        IllegalArgumentException emptyIae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> SnowflakeChannelConfig.builder().build(databaseName, schemaName, ""));
        Assertions.assertEquals((Object)"Invalid table name", (Object)emptyIae.getMessage());
        IllegalArgumentException nullIae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> SnowflakeChannelConfig.builder().build(databaseName, schemaName, null));
        Assertions.assertEquals((Object)"Invalid table name", (Object)nullIae.getMessage());
    }
}

