/*
 * Decompiled with CFR 0.152.
 */
package io.delta.storage;

import com.google.common.annotations.VisibleForTesting;
import io.delta.storage.ExternalCommitEntry;
import io.delta.storage.HadoopFileSystemLogStore;
import io.delta.storage.internal.FileNameUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemException;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseExternalLogStore
extends HadoopFileSystemLogStore {
    private static final Logger LOG = LoggerFactory.getLogger(BaseExternalLogStore.class);

    public BaseExternalLogStore(Configuration configuration) {
        super(configuration);
    }

    public Iterator<FileStatus> listFrom(Path path, Configuration configuration) throws IOException {
        FileSystem fileSystem = path.getFileSystem(configuration);
        Path path2 = this.stripUserInfo(fileSystem.makeQualified(path));
        Path path3 = this.getTablePath(path2);
        Optional<ExternalCommitEntry> optional = this.getLatestExternalEntry(path3);
        if (optional.isPresent() && !optional.get().complete) {
            this.fixDeltaLog(fileSystem, optional.get());
        }
        return super.listFrom(path, configuration);
    }

    public void write(Path path, Iterator<String> iterator, Boolean bl, Configuration configuration) throws IOException {
        FileSystem fileSystem = path.getFileSystem(configuration);
        Path path2 = this.stripUserInfo(fileSystem.makeQualified(path));
        if (bl.booleanValue()) {
            this.writeActions(fileSystem, path, iterator);
            return;
        }
        Path path3 = this.getTablePath(path2);
        if (FileNameUtils.isDeltaFile((Path)path)) {
            long l = FileNameUtils.deltaVersion((Path)path);
            if (l > 0L) {
                long l2 = l - 1L;
                Path path4 = new Path(path3, "_delta_log");
                Path path5 = FileNameUtils.deltaFile((Path)path4, (long)l2);
                String string = path5.getName();
                Optional<ExternalCommitEntry> optional = this.getExternalEntry(path3.toString(), string);
                if (optional.isPresent() && !optional.get().complete) {
                    this.fixDeltaLog(fileSystem, optional.get());
                } else if (!fileSystem.exists(path5)) {
                    throw new FileSystemException(String.format("previous commit %s doesn't exist", path5));
                }
            } else {
                String string = path.getName();
                Optional<ExternalCommitEntry> optional = this.getExternalEntry(path3.toString(), string);
                if (optional.isPresent() && optional.get().complete && !fileSystem.exists(path)) {
                    throw new FileSystemException(String.format("Old entries for table %s still exist in the external store", path3));
                }
            }
        }
        String string = this.createTemporaryPath(path2);
        ExternalCommitEntry externalCommitEntry = new ExternalCommitEntry(path3, path2.getName(), string, false, null);
        this.writeActions(fileSystem, externalCommitEntry.absoluteTempPath(), iterator);
        this.putExternalEntry(externalCommitEntry, false);
        try {
            this.writeCopyTempFile(fileSystem, externalCommitEntry.absoluteTempPath(), path2);
            this.writePutCompleteDbEntry(externalCommitEntry);
        }
        catch (Throwable throwable) {
            LOG.info("{}: ignoring recoverable error", (Object)throwable.getClass().getSimpleName(), (Object)throwable);
        }
    }

    public Boolean isPartialWriteVisible(Path path, Configuration configuration) {
        return false;
    }

    protected void writeActions(FileSystem fileSystem, Path path, Iterator<String> iterator) throws IOException {
        LOG.debug("writeActions to: {}", (Object)path);
        FSDataOutputStream fSDataOutputStream = fileSystem.create(path, true);
        while (iterator.hasNext()) {
            byte[] byArray = String.format("%s\n", iterator.next()).getBytes(StandardCharsets.UTF_8);
            fSDataOutputStream.write(byArray);
        }
        fSDataOutputStream.close();
    }

    protected String createTemporaryPath(Path path) {
        String string = UUID.randomUUID().toString();
        return String.format(".tmp/%s.%s", path.getName(), string);
    }

    protected Path getTablePath(Path path) {
        return path.getParent().getParent();
    }

    protected abstract void putExternalEntry(ExternalCommitEntry var1, boolean var2) throws IOException;

    protected abstract Optional<ExternalCommitEntry> getExternalEntry(String var1, String var2) throws IOException;

    protected abstract Optional<ExternalCommitEntry> getLatestExternalEntry(Path var1) throws IOException;

    @VisibleForTesting
    protected void writeCopyTempFile(FileSystem fileSystem, Path path, Path path2) throws IOException {
        this.copyFile(fileSystem, path, path2);
    }

    @VisibleForTesting
    protected void writePutCompleteDbEntry(ExternalCommitEntry externalCommitEntry) throws IOException {
        this.putExternalEntry(externalCommitEntry.asComplete(), true);
    }

    @VisibleForTesting
    protected void fixDeltaLogCopyTempFile(FileSystem fileSystem, Path path, Path path2) throws IOException {
        this.copyFile(fileSystem, path, path2);
    }

    @VisibleForTesting
    protected void fixDeltaLogPutCompleteDbEntry(ExternalCommitEntry externalCommitEntry) throws IOException {
        this.putExternalEntry(externalCommitEntry.asComplete(), true);
    }

    private void fixDeltaLog(FileSystem fileSystem, ExternalCommitEntry externalCommitEntry) throws IOException {
        if (externalCommitEntry.complete) {
            return;
        }
        int n = 0;
        boolean bl = false;
        while (true) {
            LOG.debug("trying to fix: {}", (Object)externalCommitEntry.fileName);
            try {
                if (!bl && !fileSystem.exists(externalCommitEntry.absoluteFilePath())) {
                    this.fixDeltaLogCopyTempFile(fileSystem, externalCommitEntry.absoluteTempPath(), externalCommitEntry.absoluteFilePath());
                    bl = true;
                }
                this.fixDeltaLogPutCompleteDbEntry(externalCommitEntry);
                LOG.info("fixed {}", (Object)externalCommitEntry.fileName);
                return;
            }
            catch (Throwable throwable) {
                LOG.info("{}:", (Object)throwable.getClass().getSimpleName(), (Object)throwable);
                if (n >= 3) {
                    throw throwable;
                }
                ++n;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(FileSystem fileSystem, Path path, Path path2) throws IOException {
        LOG.debug("copy file: {} -> {}", (Object)path, (Object)path2);
        FSDataInputStream fSDataInputStream = fileSystem.open(path);
        FSDataOutputStream fSDataOutputStream = fileSystem.create(path2, true);
        try {
            IOUtils.copy((InputStream)fSDataInputStream, (OutputStream)fSDataOutputStream);
            fSDataOutputStream.close();
        }
        finally {
            fSDataInputStream.close();
        }
    }

    private Path stripUserInfo(Path path) {
        URI uRI = path.toUri();
        try {
            URI uRI2 = new URI(uRI.getScheme(), null, uRI.getHost(), uRI.getPort(), uRI.getPath(), uRI.getQuery(), uRI.getFragment());
            return new Path(uRI2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }
}

