/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.lang.parse;

import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.lang.generated.Chunker;
import io.deephaven.lang.generated.ChunkerDocument;
import io.deephaven.lang.generated.ParseException;
import io.deephaven.lang.parse.LspTools;
import io.deephaven.lang.parse.ParsedDocument;
import io.deephaven.lang.parse.PendingParse;
import io.deephaven.proto.backplane.script.grpc.ChangeDocumentRequest;
import io.deephaven.proto.backplane.script.grpc.DocumentRange;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CompletionParser
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletionParser.class);
    private final Map<String, PendingParse> docs = new ConcurrentHashMap<String, PendingParse>();

    public static String updateDocumentChanges(String uri, int version, String document, List<ChangeDocumentRequest.TextDocumentContentChangeEvent> changes) {
        for (ChangeDocumentRequest.TextDocumentContentChangeEventOrBuilder textDocumentContentChangeEventOrBuilder : changes) {
            DocumentRange range = textDocumentContentChangeEventOrBuilder.getRange();
            int length = textDocumentContentChangeEventOrBuilder.getRangeLength();
            int offset = LspTools.getOffsetFromPosition((String)document, range.getStart());
            if (offset < 0) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn().append((CharSequence)"Invalid change in document ").append((CharSequence)uri).append((CharSequence)"[").append(version).append((CharSequence)"] @").append(range.getStart().getLine()).append((CharSequence)":").append(range.getStart().getCharacter()).endl();
                }
                return null;
            }
            String prefix = offset > 0 && offset <= ((String)document).length() ? ((String)document).substring(0, offset) : "";
            String suffix = offset + length < ((String)document).length() ? ((String)document).substring(offset + length) : "";
            document = prefix + textDocumentContentChangeEventOrBuilder.getText() + suffix;
        }
        return document;
    }

    public ParsedDocument parse(String document) throws ParseException {
        Chunker chunker = new Chunker(document);
        ChunkerDocument doc = chunker.Document();
        return new ParsedDocument(doc, document);
    }

    public void open(String text, String uri, String version) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace().append((CharSequence)"Opening document ").append((CharSequence)uri).append((CharSequence)"[").append((CharSequence)version).append((CharSequence)"] ->\n").append((CharSequence)text).endl();
        }
        this.startParse(uri).requestParse(String.valueOf(version), text, false);
    }

    private PendingParse startParse(String uri) {
        return this.docs.computeIfAbsent(uri, k -> new PendingParse(uri));
    }

    public void update(String uri, int version, List<ChangeDocumentRequest.TextDocumentContentChangeEvent> changes) {
        boolean forceParse;
        PendingParse doc;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace().append((CharSequence)"Updating document ").append((CharSequence)uri).append((CharSequence)" [").append(version).append((CharSequence)"] all docs: ").append((CharSequence)this.docs.keySet().toString()).append((CharSequence)" changes: ").append((CharSequence)changes.toString()).endl();
        }
        if ((doc = this.docs.get(uri)) == null) {
            doc = this.startParse(uri);
            forceParse = false;
        } else {
            doc.invalidate();
            forceParse = true;
        }
        String document = doc.getText();
        document = CompletionParser.updateDocumentChanges(uri, version, document, changes);
        if (document == null) {
            return;
        }
        doc.requestParse(Integer.toString(version), document, forceParse);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace().append((CharSequence)"Finished updating ").append((CharSequence)uri).append((CharSequence)" [").append(version).append((CharSequence)"]").endl();
        }
    }

    public void remove(String uri) {
        PendingParse was = this.docs.remove(uri);
        if (was != null) {
            was.cancel();
        }
    }

    public String getText(String uri) {
        PendingParse doc = this.docs.get(uri);
        if (doc == null) {
            throw new IllegalStateException("Unable to find parsed document " + uri);
        }
        return doc.getText();
    }

    public ParsedDocument finish(String uri) {
        PendingParse doc = this.docs.get(uri);
        if (doc == null) {
            throw new IllegalStateException("Unable to find parsed document " + uri);
        }
        return doc.finishParse().orElseThrow(() -> new IllegalStateException("Unable to complete document parsing for " + uri));
    }

    @Override
    public void close() {
        this.docs.keySet().forEach(this::remove);
    }
}

