/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.lang.generated;

import io.deephaven.lang.generated.Chunker;
import io.deephaven.lang.generated.ChunkerVisitor;
import io.deephaven.lang.generated.SimpleNode;
import io.deephaven.lang.generated.Token;

public class ChunkerString
extends SimpleNode {
    private String quoteType;
    private String body;

    public ChunkerString(int id) {
        super(id);
    }

    public ChunkerString(Chunker p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(ChunkerVisitor visitor, Object data) {
        return visitor.visitChunkerString(this, data);
    }

    public ChunkerString initialize(String quoteType, String body, boolean wellFormed) {
        int type;
        this.quoteType = quoteType;
        this.body = body;
        this.setWellFormed(wellFormed);
        switch (quoteType) {
            case "\"": {
                type = 20;
                break;
            }
            case "'": {
                type = 21;
                break;
            }
            case "'''": {
                type = 51;
                break;
            }
            case "\"\"\"": {
                type = 50;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid quote type: " + quoteType);
            }
        }
        assert (this.firstToken != null);
        assert (this.lastToken != null);
        assert (this.firstToken.to(this.lastToken).anyMatch(this.lastToken::equals));
        block17: for (Token token : this.lastToken.toReverse(this.firstToken)) {
            switch (token.kind) {
                case 20: 
                case 21: 
                case 50: 
                case 51: {
                    assert (token.kind == type) : "Closing quote does not match opening quote";
                }
                case 8: 
                case 11: {
                    if (!"'".equals(token.image)) {
                        this.setWellFormed(false);
                    }
                }
                case 7: 
                case 10: {
                    this.lastToken = token;
                    break block17;
                }
                default: {
                    continue block17;
                }
            }
        }
        return this;
    }

    public String getRaw() {
        StringBuilder b = new StringBuilder();
        Token node = this.firstToken;
        assert (node.image.equals(this.quoteType));
        node = node.next;
        while (node.kind == 10 || node.kind == 7) {
            b.append(node.image);
            node = node.next;
        }
        assert (b.toString().equals(this.body)) : b + " != " + this.body;
        return b.toString();
    }

    public String getQuoteType() {
        return this.quoteType;
    }
}

