/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.lang.generated;

import io.deephaven.lang.generated.Token;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public interface ChunkerMixin {
    public static final char[] EQUAL_COMMA_OR_DASH;
    public static final char[] COMMA_OR_DASH_OR_DOT;
    public static final char[] ANY_EXPR;
    public static final Set<Character> ALLOW_TYPE_PARAMS;
    public static final Set<Character> ALLOW_TYPE_OR_DOT;
    public static final Set<Character> ALLOW_EQUALS;
    public static final Set<Character> ALLOW_ASSIGN;
    public static final Set<Character> ALLOW_COLON;
    public static final Set<Character> ALLOW_EQUAL_COMMA_OR_DASH;
    public static final Set<Character> ALLOW_COMMA_OR_DASH_OR_DOT;
    public static final Set<Character> ALLOW_PAREN;
    public static final Set<Character> ALLOW_ANY;

    public static Set<Character> set(char ... cs) {
        HashSet<Character> s = new HashSet<Character>();
        for (char c : cs) {
            s.add(Character.valueOf(c));
        }
        return s;
    }

    default public void report(int code, Throwable e) {
        e.printStackTrace();
        throw new AssertionError("implement report()", e);
    }

    public char next() throws IOException;

    public Token curToken();

    public boolean isLookingAhead();

    default public PeekStream peek() {
        return new PeekStream(this);
    }

    default public boolean isTypedAssign() {
        return this.peek().whitespace().identifier(ALLOW_TYPE_PARAMS).whitespace().typeParams(false).whitespace().identifier(ALLOW_ASSIGN).whitespace().assign().matches(true);
    }

    default public boolean isAssign() {
        return this.peek().whitespace().identifier(ALLOW_ASSIGN).whitespace().assign().matches(true);
    }

    default public boolean isScope() {
        return this.peek().whitespace().identifier(ALLOW_TYPE_OR_DOT).whitespace().typeParams(false).whitespace().exact('.').whitespace().nextChar(Character::isJavaIdentifierStart).matches(true);
    }

    default public boolean isBinExprAcrossNewline() {
        PeekStream stream = this.peek();
        return stream.whitespace().withAny(stream.is('.', '!', '?', ':', '*', '<', '>', '=', '+', '-', '/', '%', '&', '|', '^', '~'), stream.is("in"), stream.is("as"), stream.is("is"), stream.is("instanceof")).whitespace().matches(true);
    }

    default public boolean isPythonAnnotated() {
        return this.peek().whitespace().identifier(ALLOW_COLON).whitespace().exact(':').matches(true);
    }

    default public boolean isTypedInvoke(boolean ctor) {
        PeekStream matcher = this.peek().whitespace();
        if (!ctor) {
            matcher.typeParams(true).whitespace();
        }
        matcher.identifier(ALLOW_PAREN).whitespace();
        if (ctor) {
            matcher.typeParams(true).whitespace();
        }
        return matcher.eofOr('(').matches(true);
    }

    default public boolean isClassDecl() {
        return this.peek().whitespace().exact("class").whitespace().matches(true);
    }

    default public boolean isParamList() {
        PeekStream stream = this.peek();
        return stream.whitespace().with(new PeekStream.Checker(){
            char prev = '\u0000';

            @Override
            public int check(char c) {
                switch (c) {
                    case '>': {
                        if (this.prev == '-') {
                            return 1;
                        }
                    }
                    case '-': {
                        this.prev = c;
                        return 0;
                    }
                    case '\u0000': 
                    case '\n': 
                    case '\r': {
                        return -1;
                    }
                }
                this.prev = c;
                return 0;
            }
        }).matches(true);
    }

    public void back(int var1, int var2);

    public Token token();

    default public Token eatJunk() {
        StringBuilder b;
        int backup;
        Token next;
        Token root;
        Token token;
        block10: {
            token = this.token();
            root = new Token(0, "");
            root.image = "";
            root.copyToken(token);
            root.kind = 0;
            root.startIndex = token.endIndex;
            root.beginLine = token.endLine;
            root.beginColumn = token.endColumn;
            next = token;
            while (next.next != null) {
                next = next.next;
                next.kind = 0;
            }
            token.next = root;
            backup = 1;
            b = new StringBuilder();
            try {
                while (true) {
                    char c = this.next();
                    switch (c) {
                        case '\n': 
                        case '\r': {
                            break block10;
                        }
                        default: {
                            b.append(c);
                            break;
                        }
                    }
                }
            }
            catch (IOException eof) {
                backup = 0;
            }
        }
        this.back(backup, token.tokenBegin);
        if (next == token) {
            root.image = b.toString();
            root.endIndex = root.startIndex + b.length();
            root.endColumn += b.length();
        } else {
            Token junk = new Token(0, "");
            if (!2.$assertionsDisabled && next.next != null) {
                throw new AssertionError();
            }
            junk.copyToken(next);
            junk.kind = 0;
            junk.image = b.toString();
            junk.startIndex = next.endIndex;
            junk.endIndex = junk.startIndex + b.length();
            junk.beginColumn = junk.endColumn + (b.length() == 0 ? 0 : 1);
            junk.endColumn += b.length();
            junk.specialToken = null;
            next.next = junk;
        }
        return root;
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        EQUAL_COMMA_OR_DASH = new char[]{'=', ',', '-'};
        COMMA_OR_DASH_OR_DOT = new char[]{',', '-', '.'};
        ANY_EXPR = new char[]{',', '-', '.', '(', ')', '+', '*', '/', '%', '!', '?', ':', '^', '[', ']', '{', '}', '$'};
        ALLOW_TYPE_PARAMS = ChunkerMixin.set('<');
        ALLOW_TYPE_OR_DOT = ChunkerMixin.set('.', '<');
        ALLOW_EQUALS = ChunkerMixin.set('=');
        ALLOW_ASSIGN = ChunkerMixin.set('=', '+', '-', '*', '/', '@', '&', '|', '^', '>', '<');
        ALLOW_COLON = ChunkerMixin.set(':');
        ALLOW_EQUAL_COMMA_OR_DASH = ChunkerMixin.set(EQUAL_COMMA_OR_DASH);
        ALLOW_COMMA_OR_DASH_OR_DOT = ChunkerMixin.set(COMMA_OR_DASH_OR_DOT);
        ALLOW_PAREN = ChunkerMixin.set('<', '(');
        ALLOW_ANY = ChunkerMixin.set(ANY_EXPR);
    }

    public static class PeekStream {
        static final int SUCCESS = 1;
        static final int MORE = 0;
        static final int NEXT = 2;
        static final int FAILURE = -1;
        private final ChunkerMixin chunker;
        private final List<Checker> matchers;

        PeekStream(ChunkerMixin chunker) {
            this.chunker = chunker;
            this.matchers = new ArrayList<Checker>();
        }

        public PeekStream whitespace() {
            this.matchers.add(this.ws());
            return this;
        }

        PeekStream nextChar(Predicate<Character> matcher) {
            this.matchers.add(c -> matcher.test(Character.valueOf(c)) ? 1 : -1);
            return this;
        }

        public Checker ws() {
            return this.ws(false);
        }

        public Checker ws(boolean required) {
            return new CheckerWhitespace(required);
        }

        public PeekStream identifier(Set<Character> allowedEndings) {
            this.matchers.add(this.id(allowedEndings));
            return this;
        }

        private Checker id(final Set<Character> allowedEndings) {
            class IdChecker
            implements Checker {
                boolean part;

                IdChecker() {
                }

                @Override
                public int check(char value) {
                    if (this.part) {
                        return Character.isJavaIdentifierPart(value) ? 0 : (Character.isWhitespace(value) || allowedEndings.contains(Character.valueOf(value)) ? 2 : -1);
                    }
                    this.part = true;
                    return Character.isJavaIdentifierStart(value) ? 0 : -1;
                }
            }
            return new IdChecker();
        }

        PeekStream typeParams(boolean required) {
            this.matchers.add(this.typeParamChecker(required));
            return this;
        }

        Checker typeParamChecker(final boolean required) {
            class TypeParamChecker
            implements Checker {
                private int depth;

                TypeParamChecker() {
                }

                @Override
                public int check(char value) {
                    switch (this.depth) {
                        case 0: {
                            ++this.depth;
                            return value == '<' ? 0 : (required ? -1 : 2);
                        }
                        case 1: {
                            if (value != '>') break;
                            return 1;
                        }
                    }
                    switch (value) {
                        case '<': {
                            ++this.depth;
                            return 0;
                        }
                        case '>': {
                            --this.depth;
                            return 0;
                        }
                        case '&': 
                        case ',': 
                        case '.': 
                        case '?': {
                            return 0;
                        }
                    }
                    return Character.isJavaIdentifierPart(value) || Character.isWhitespace(value) ? 0 : -1;
                }
            }
            return new TypeParamChecker();
        }

        private PeekStream with(Checker checker) {
            this.matchers.add(checker);
            return this;
        }

        private PeekStream withAny(Checker ... checkers) {
            this.matchers.add(this.any(checkers));
            return this;
        }

        private Checker any(final Checker ... checkers) {
            class AnyChecker
            implements Checker {
                AnyChecker() {
                }

                @Override
                public int check(char c) {
                    int best = -1;
                    block5: for (int i = 0; i < checkers.length; ++i) {
                        int result = checkers[i].check(c);
                        switch (result) {
                            case -1: {
                                checkers[i] = Checker.FAILED;
                                continue block5;
                            }
                            case 1: 
                            case 2: {
                                return result;
                            }
                            case 0: {
                                best = 0;
                            }
                        }
                    }
                    return best;
                }
            }
            return new AnyChecker();
        }

        public PeekStream eofOr(char ... cs) {
            this.matchers.add(this.eof(cs));
            return this;
        }

        public PeekStream assign() {
            char[] firstMatch = new char[]{'\u0000'};
            this.matchers.add(match -> {
                firstMatch[0] = match;
                switch (match) {
                    case '=': {
                        return 2;
                    }
                    case '%': 
                    case '&': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': 
                    case '<': 
                    case '>': 
                    case '@': 
                    case '^': 
                    case '|': {
                        return 1;
                    }
                }
                return -1;
            });
            this.matchers.add(match -> {
                if (firstMatch[0] == '=') {
                    return 2;
                }
                switch (match) {
                    case '=': {
                        return firstMatch[0] == '<' || firstMatch[0] == '>' ? -1 : 1;
                    }
                    case '*': 
                    case '<': 
                    case '>': {
                        if (firstMatch[0] != match) break;
                        return 1;
                    }
                }
                return -1;
            });
            this.matchers.add(match -> match == '=' ? 1 : -1);
            this.matchers.add(match -> {
                if (Character.isWhitespace(match)) {
                    return 2;
                }
                switch (match) {
                    case '=': 
                    case '~': {
                        return -1;
                    }
                }
                return 2;
            });
            return this;
        }

        public EofChecker eof(char ... cs) {
            return match -> {
                if (match == '\u0000') {
                    return 1;
                }
                for (char c : cs) {
                    if (match != c) continue;
                    return 1;
                }
                return -1;
            };
        }

        public PeekStream exact(char ... cs) {
            this.matchers.add(this.is(cs));
            return this;
        }

        public PeekStream exact(String cs) {
            this.matchers.add(this.is(cs));
            return this;
        }

        public Checker is(char ... cs) {
            return match -> {
                for (char c : cs) {
                    if (match != c) continue;
                    return 1;
                }
                return -1;
            };
        }

        public Checker is(final String s) {
            class IsChecker
            implements Checker {
                private int pntr;

                IsChecker() {
                }

                @Override
                public int check(char c) {
                    if (c == s.charAt(this.pntr)) {
                        ++this.pntr;
                        return this.pntr >= s.length() ? 1 : 0;
                    }
                    return -1;
                }
            }
            return new IsChecker();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public boolean matches(boolean peeking) {
            block35: {
                tok = this.chunker.curToken().next;
                begin = tok == null ? -1 : tok.tokenBegin;
                itr = this.matchers.iterator();
                if (!PeekStream.$assertionsDisabled && !itr.hasNext()) {
                    throw new AssertionError((Object)"Cannot match w/out a Checker...");
                }
                checker = itr.next();
                c = '\u0000';
                read = true;
                isEof = false;
                success = false;
                while (tok != null) {
                    chars = tok.image.toCharArray();
                    tok = tok.next;
                    i = 0;
                    block20: while (i < chars.length) {
                        if (read) {
                            c = chars[i++];
                        } else {
                            read = true;
                            ++i;
                        }
                        result = checker.check(c);
                        switch (result) {
                            case 2: {
                                read = false;
                                if (itr.hasNext()) {
                                    --i;
                                }
                            }
                            case 1: {
                                if (itr.hasNext()) {
                                    checker = itr.next();
                                } else {
                                    return true;
                                }
                            }
                            case 0: {
                                continue block20;
                            }
                            case -1: {
                                return false;
                            }
                        }
                        throw new AssertionError((Object)("missing case " + result));
                    }
                }
                backup = 0;
                block21: while (true) {
                    block22: while (checker != null) {
                        block37: {
                            block36: {
                                if (!read) break block36;
                                try {
                                    c = this.chunker.next();
                                    ++backup;
                                }
                                catch (IOException e) {
                                    if (!(checker instanceof EofChecker)) {
                                        if (checker instanceof CheckerWhitespace && !itr.hasNext()) {
                                            success = true;
                                            break block35;
                                        }
                                        var13_17 = false;
                                        if (peeking || !success) {
                                            this.chunker.back(backup, begin);
                                        }
                                        return var13_17;
                                    }
                                    isEof = true;
                                }
                                break block37;
                            }
                            read = true;
                        }
                        result = checker.check(c);
                        switch (result) {
                            case 2: {
                                read = false;
                            }
                            case 1: {
                                if (!itr.hasNext()) {
                                    success = true;
                                    ** break;
lbl69:
                                    // 1 sources

                                    break block35;
                                }
                                checker = itr.next();
                            }
                            case 0: {
                                continue block21;
                            }
                            case -1: {
                                success = false;
                                var12_16 = false;
                                return var12_16;
                            }
                            default: {
                                continue block22;
                            }
                        }
                    }
                    break block35;
                    break;
                }
                finally {
                    if (peeking || !success) {
                        this.chunker.back(backup, begin);
                    }
                }
            }
            if (!isEof || !success) {
                // empty if block
            }
            return success;
        }

        class CheckerWhitespace
        implements Checker {
            private final boolean required;

            public CheckerWhitespace(boolean required) {
                this.required = required;
            }

            @Override
            public int check(char c) {
                return Character.isWhitespace(c) ? 0 : (this.required ? -1 : 2);
            }
        }

        static interface EofChecker
        extends Checker {
            public static EofChecker of(Checker check) {
                return check instanceof EofChecker ? (EofChecker)check : check::check;
            }

            public static EofChecker create(EofChecker check) {
                return check;
            }
        }

        static interface Checker {
            public static final Checker FAILED = c -> -1;

            public int check(char var1);

            default public Checker then(final Checker ... next) {
                final Checker self = this;
                return new Checker(){
                    Checker checker;
                    int index;
                    {
                        this.checker = self;
                        this.index = -1;
                    }

                    @Override
                    public int check(char c) {
                        int result = this.checker.check(c);
                        switch (result) {
                            case -1: 
                            case 0: {
                                return result;
                            }
                            case 1: {
                                if (++this.index < next.length) {
                                    this.checker = next[this.index];
                                    return 0;
                                }
                                return 1;
                            }
                            case 2: {
                                block10: while (++this.index < next.length) {
                                    this.checker = next[this.index];
                                    result = this.checker.check(c);
                                    switch (result) {
                                        case -1: 
                                        case 0: {
                                            return result;
                                        }
                                        case 2: {
                                            continue block10;
                                        }
                                        case 1: {
                                            if (++this.index < next.length) {
                                                this.checker = next[this.index];
                                                return 0;
                                            }
                                            return 1;
                                        }
                                    }
                                }
                                break;
                            }
                        }
                        return result;
                    }
                };
            }

            default public Checker maybe(final boolean whitespace, final char ... match) {
                class MaybeCheck
                implements Checker {
                    private boolean hasSucceeded;

                    MaybeCheck() {
                    }

                    @Override
                    public int check(char c) {
                        for (char m : match) {
                            if (c != m && (!whitespace || !Character.isWhitespace(m))) continue;
                            this.hasSucceeded = true;
                            return 0;
                        }
                        return this.hasSucceeded ? 1 : 2;
                    }
                }
                return new MaybeCheck();
            }
        }
    }

    public static interface CharPredicate {
        public boolean match(char var1);
    }
}

