/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.lang.generated;

import io.deephaven.lang.api.HasScope;
import io.deephaven.lang.api.IsScope;
import io.deephaven.lang.generated.Chunker;
import io.deephaven.lang.generated.ChunkerVisitor;
import io.deephaven.lang.generated.Node;
import io.deephaven.lang.generated.ScopedNode;
import io.deephaven.lang.generated.Token;
import java.util.Collections;
import java.util.List;

public class ChunkerBinaryExpression
extends ScopedNode {
    private Node left;
    private Token joiner;
    private Node right;

    public ChunkerBinaryExpression(int id) {
        super(id);
    }

    public ChunkerBinaryExpression(Chunker p, int id) {
        super(p, id);
    }

    @Override
    public Node rescope(List<IsScope> scope) {
        super.rescope(scope);
        if (this.left instanceof IsScope && this.joiner.image.equals(".") && this.right instanceof HasScope) {
            this.right.addScope(Collections.singletonList((IsScope)this.left));
            return this.right;
        }
        return this;
    }

    @Override
    public void setScope(List<IsScope> scopes) {
        assert (null == ((HasScope)this.left).getScope() || ((HasScope)this.left).getScope().isEmpty());
        this.left.addScope(scopes);
    }

    @Override
    public Object jjtAccept(ChunkerVisitor visitor, Object data) {
        return visitor.visitChunkerBinaryExpression(this, data);
    }

    public void setLeft(Node left) {
        left.maybeDetach();
        this.left = left;
        assert (this.right == null);
        this.firstToken = left.jjtGetFirstToken();
        left.jjtSetParent(this);
        this.jjtInsertChild(left, 0);
    }

    public Node getLeft() {
        return this.left;
    }

    public void setJoiner(Token joiner) {
        this.joiner = joiner;
    }

    public Token getJoiner() {
        return this.joiner;
    }

    public void setRight(Node right) {
        right.maybeDetach();
        this.right = right;
        assert (this.left != null);
        this.lastToken = right.jjtGetLastToken();
        right.jjtSetParent(this);
        this.jjtAddChild(right, this.jjtGetNumChildren());
    }

    public Node getRight() {
        return this.right;
    }
}

