/* Chunker.java */
/* Generated By:JJTree&JavaCC: Do not edit this line. Chunker.java */
package io.deephaven.lang.generated;

import io.deephaven.lang.api.ChunkerInvokable;
import io.deephaven.lang.api.IsScope;
import io.deephaven.lang.api.ParseCancelled;
import io.deephaven.lang.api.ParseState;

import java.io.IOException;
import java.util.*;

import static io.deephaven.lang.shared.lsp.DiagnosticCode.MALFORMED_TYPE_ARGUMENT;
import static java.util.Collections.singletonList;

public class Chunker implements/*@bgen(jjtree)*/ ChunkerTreeConstants,ChunkerMixin, ChunkerConstants {/*@bgen(jjtree)*/
  protected JJTChunkerState jjtree = new JJTChunkerState();
    private final ParseState root = new ParseState(null);
    private volatile ParseState current = root;
    private final Stack<ParseState> stack = new Stack<ParseState>();
    private final IdentityHashMap<Node, ParseState> states = new IdentityHashMap<Node, ParseState>();
    private ChunkerInvokable invoker;

    public static void main(String[] args) throws Exception {
        final Chunker ast;
        if (args.length == 0) {
            ast = new Chunker(new StreamProvider(System.in));
        } else {
            ast = new Chunker(new StreamProvider(new java.io.StringReader(args[0])));
        }
        ast.Document();
    }

    void report(int code) {
        // no-op
    }

    void jjtreeOpenNodeScope(Node n){
        ParseState state = new ParseState(n);
        ParseState was = states.put(n, state);
        assert was == null : "State map is screwy; " + was + " and " + state + " both added for " + n;
        current.addChild(state);
        current = state;
    }

    void jjtreeCloseNodeScope(Node n){
        ParseState is = states.get(n);
        assert is != null : "State map is screwy; no entry for " + n + " found in " + states;
        current = is.finish();
    }


  public boolean isLookingAhead() {
    return jj_lookingAhead;
  }

  public Token curToken() {
    return jj_lookingAhead ? jj_scanpos : token;
  }

  @Override
  public char next() throws IOException {
    // next() is much nicer to type....
    return jj_input_stream.readChar();
  }

  @Override
  public void back(int backup, int tokenBegin) {
    jj_input_stream.backup(backup);
    if (tokenBegin != -1) {
      jj_input_stream.tokenBegin = tokenBegin;
    }
  }

  void putBackTokens(boolean clearCurrent) {
    // instead of trying to mess with the insanity of the jjt runtime state,
    // lets instead make our peeking-methods look at existing token images;
    // if there are cases where a peek method matches and an existing token is of the wrong type,
    // then we may need to fix on a case-by-case basis (adding extra "recovery productions")

    // This should at least be simplified by exposing a simple character stream,
    // which first reads the existing tokens, and then looks at the underlying input stream.
    // We may also want to behave differently when jj_lookingAhead is true. i.e. only actually
    // put tokens back when we aren't looking ahead, so we don't attempt to mutate the stack
    // until the moment we are actually creating the tokens protected by a peeker method.


    jj_ntk = -1; // erase knowledge of any existing tokens.

      jj_lastpos = jj_scanpos;
      jj_la = 1;
    if (token == null) {
      return;
    }

    final Token toPutBack = clearCurrent ? token : token.next;
    int begin;
    if (toPutBack != null) {
        begin = toPutBack.tokenBegin;
    } else {
        begin = -1;
    }
    int backup = putBack(clearCurrent ? token : token.next);
    if (clearCurrent) {
      token.next = null;
    }
    back(backup, begin);
  }

  int putBack(Token token) {
    if (token == null) {
      return 0;
    }
    // Only put back tokens we haven't already put back.
    // We want to leave the tokens attached, because
    // we may accidentally detach a legitimate token if a lookahead fails.
    if (token.detached) {
      return 0;
    }
    token.detached = true;
    int backup = putBack(token.specialToken);
    backup += token.image.length();
    Token putBack = token.next;
    token.next = null;
    return backup + putBack(putBack);
  }

  void fixState(Token token) {
    ParseState p = current;
    while (p.getSrc() != null) {
      if (p.getSrc().jjtGetLastToken() == null) {
        p.getSrc().addJunk(token);
      }
      p = p.getParent();
    }
  }

  public Token token() {
    return token;
  }

  public void checkInterrupts() {
    if (Thread.interrupted()) {
      throw new ParseCancelled();
    }
  }

// Do not define new token regex here, unless they are for junk nodes!
// The actual AST nodes defined below
  final public 
ChunkerDocument Document() throws ParseException {/*@bgen(jjtree) Document */
ChunkerDocument jjtn000 = new ChunkerDocument(this, JJTDOCUMENT);
boolean jjtc000 = true;
jjtree.openNodeScope(jjtn000);
jjtreeOpenNodeScope(jjtn000);
jjtn000.jjtSetFirstToken(getToken(1));Node n = jjtn000;
    try {
      EatStatements(true);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
// document is done.  Fill in backlinks.
      jjtn000.jjtGetFirstToken().addBackLinks();
      return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       if (jjtree.nodeCreated()) {
        jjtreeCloseNodeScope(jjtn000);
       }
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Node EatStatements(boolean persistent) throws ParseException {Node n = null;
    label_1:
    while (true) {
      if (jj_2_1(1)) {
        ;
      } else {
        break label_1;
      }
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NEWLINE:{
          n = Newline();
          break;
          }
        case WHITESPACE:{
          // TODO: pass leading whitespace into Statement.
                   // We do not let Statement() gather leading Whitespace(),
                   // as that could result in it being matched eagerly,
                   // and we don't want to pay for LL(2+).
                   // for now, we can easily search to the left of Statement()'s first token,
                   // so we'll avoid any leading whitespace in any production.
                   n = Whitespace();
          break;
          }
        default:
          jj_la1[0] = jj_gen;
          if (jj_2_2(1)) {
            n = Statement();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } catch (ParseException e) {
// Whenever there is an unhandled parse exception,
         // gobble up the rest of the line and attach to previous node.
         if (n != null) {
           token = n.addJunk(eatJunk());
         }
         fixState(token);
         if (!persistent) {
           return n;
         }
      }
    }
return n;
}

  final public ChunkerStatement Statement() throws ParseException {/*@bgen(jjtree) Statement */
ChunkerStatement jjtn000 = new ChunkerStatement(this, JJTSTATEMENT);
boolean jjtc000 = true;
jjtree.openNodeScope(jjtn000);
jjtreeOpenNodeScope(jjtn000);
jjtn000.jjtSetFirstToken(getToken(1));Node expr = null; ChunkerAssign assignment = null;
Token ignore = null;
List<ChunkerAnnotation> annotations = Collections.emptyList();
checkInterrupts();
    try {
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AT:{
          annotations = Annotations();
expr = annotations.get(annotations.size() - 1);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:{
            Whitespace();
            break;
            }
          default:
            jj_la1[1] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[2] = jj_gen;
          ;
        }
        if (isTypedAssign()) {
          assignment = TypedAssign();
expr = assignment;
          if (jj_2_3(1)) {
            expr = Values();
assignment.setValue(expr);
          } else {
            ;
          }
        } else if (isAssign()) {
          assignment = Assign();
expr = assignment;
          if (jj_2_4(1)) {
            expr = Values();
assignment.setValue(expr);
          } else {
            ;
          }
        } else if (isClassDecl()) {
          expr = JavaClassDecl();
        } else if (jj_2_6(1)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case FROM_LOCAL:{
            jj_consume_token(FROM_LOCAL);
            break;
            }
          default:
            jj_la1[3] = jj_gen;
            ;
          }
          expr = Values();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:
          case ID:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WHITESPACE:{
              Whitespace();
              break;
              }
            default:
              jj_la1[4] = jj_gen;
              ;
            }
            assignment = Assign();
// set the current expression as the scope to assign.
            assignment.addScope(singletonList((IsScope)expr));
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WHITESPACE:{
              Whitespace();
              break;
              }
            default:
              jj_la1[5] = jj_gen;
              ;
            }
            if (jj_2_5(1)) {
              expr = Values();
            } else {
              ;
            }
            break;
            }
          default:
            jj_la1[6] = jj_gen;
            ;
          }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:{
          Whitespace();
expr.adopt(jjtree.popNode());
          break;
          }
        default:
          jj_la1[7] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case SEMI:{
          jj_consume_token(SEMI);
expr.addToken(token);
          break;
          }
        case COMMA:{
          jj_consume_token(COMMA);
// TODO: mark this node as something that should give type information, if any, to it's sibling.
    // when we are ready for it, finding a comma token at the end of a statement should suffice to figure it out.
    // This will be useful for groovy closure and python set detection.
    expr.addToken(token);
          break;
          }
        case COLON:{
          jj_consume_token(COLON);
// we'll want something better than this for python ... later.
    expr.addToken(token);
          break;
          }
        case CLOSURE_START:{
          jj_consume_token(CLOSURE_START);
ignore = token;
    back(1, token.tokenBegin);
          break;
          }
        case CLOSURE_END:{
          jj_consume_token(CLOSURE_END);
ignore = token;
    back(1, token.tokenBegin);
          break;
          }
        case NEWLINE:{
          Newline();
          break;
          }
        case 0:{
          Eof();

          break;
          }
        default:
          jj_la1[8] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (ParseException e) {
// Whenever there is an unhandled parse exception,
     // gobble up the rest of the line and attach to previous node.
     if (expr != null) {
       token = expr.addJunk(eatJunk());
       fixState(token);
     }
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
Token removed = jjtn000.removeToken(ignore);
      if (removed != null) {
        token = removed;
      }
      jjtn000.setAnnotations(annotations);
      return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ChunkerJavaClassDecl JavaClassDecl() throws ParseException {/*@bgen(jjtree) JavaClassDecl */
ChunkerJavaClassDecl jjtn000 = new ChunkerJavaClassDecl(this, JJTJAVACLASSDECL);
boolean jjtc000 = true;
jjtree.openNodeScope(jjtn000);
jjtreeOpenNodeScope(jjtn000);
jjtn000.jjtSetFirstToken(getToken(1));boolean wellFormed = false;
    try {
      jj_consume_token(CLASS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ID:{
          TypeDecl();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:{
            jj_consume_token(WHITESPACE);
            break;
            }
          default:
            jj_la1[9] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case EXTENDS:{
            jj_consume_token(EXTENDS);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WHITESPACE:{
              jj_consume_token(WHITESPACE);
              TypeDecl();
              label_2:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case WHITESPACE:
                case COMMA:{
                  ;
                  break;
                  }
                default:
                  jj_la1[10] = jj_gen;
                  break label_2;
                }
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case WHITESPACE:{
                  jj_consume_token(WHITESPACE);
                  break;
                  }
                default:
                  jj_la1[11] = jj_gen;
                  ;
                }
                jj_consume_token(COMMA);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case WHITESPACE:{
                  jj_consume_token(WHITESPACE);
                  break;
                  }
                default:
                  jj_la1[12] = jj_gen;
                  ;
                }
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case ID:{
                  TypeDecl();
                  break;
                  }
                default:
                  jj_la1[13] = jj_gen;
                  ;
                }
              }
              break;
              }
            default:
              jj_la1[14] = jj_gen;
              ;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WHITESPACE:{
              jj_consume_token(WHITESPACE);
              break;
              }
            default:
              jj_la1[15] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[16] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case IMPLEMENTS:{
            jj_consume_token(IMPLEMENTS);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WHITESPACE:{
              jj_consume_token(WHITESPACE);
              TypeDecl();
              label_3:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case WHITESPACE:
                case COMMA:{
                  ;
                  break;
                  }
                default:
                  jj_la1[17] = jj_gen;
                  break label_3;
                }
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case WHITESPACE:{
                  jj_consume_token(WHITESPACE);
                  break;
                  }
                default:
                  jj_la1[18] = jj_gen;
                  ;
                }
                jj_consume_token(COMMA);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case WHITESPACE:{
                  jj_consume_token(WHITESPACE);
                  break;
                  }
                default:
                  jj_la1[19] = jj_gen;
                  ;
                }
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case ID:{
                  TypeDecl();
                  break;
                  }
                default:
                  jj_la1[20] = jj_gen;
                  ;
                }
              }
              break;
              }
            default:
              jj_la1[21] = jj_gen;
              ;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WHITESPACE:{
              jj_consume_token(WHITESPACE);
              break;
              }
            default:
              jj_la1[22] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[23] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[24] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 0:
      case CLOSURE_START:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CLOSURE_START:{
          jj_consume_token(CLOSURE_START);
          EatStatements(false);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case CLOSURE_END:{
            jj_consume_token(CLOSURE_END);
wellFormed = true;
            break;
            }
          default:
            jj_la1[27] = jj_gen;
            ;
          }
          break;
          }
        case 0:{
          Eof();
          break;
          }
        default:
          jj_la1[28] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setWellFormed(wellFormed);
    return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ChunkerAssign Assign() throws ParseException {/*@bgen(jjtree) Assign */
  ChunkerAssign jjtn000 = new ChunkerAssign(this, JJTASSIGN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      Ident();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      jj_consume_token(ASSIGN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ChunkerTypedAssign TypedAssign() throws ParseException {/*@bgen(jjtree) TypedAssign */
  ChunkerTypedAssign jjtn000 = new ChunkerTypedAssign(this, JJTTYPEDASSIGN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      TypeDecl();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        ;
      }
      Ident();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        ;
      }
      jj_consume_token(ASSIGN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ChunkerTypeDecl TypeDecl() throws ParseException {/*@bgen(jjtree) TypeDecl */
  ChunkerTypeDecl jjtn000 = new ChunkerTypeDecl(this, JJTTYPEDECL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(ID);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:{
        TypeParams();
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ChunkerTypeParams TypeParams() throws ParseException {/*@bgen(jjtree) TypeParams */
  ChunkerTypeParams jjtn000 = new ChunkerTypeParams(this, JJTTYPEPARAMS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));boolean wellFormed=false;
    try {
      jj_consume_token(LT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:
      case NEWLINE:
      case ID:
      case QUEST:{
        label_4:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:
          case NEWLINE:{
            ;
            break;
            }
          default:
            jj_la1[37] = jj_gen;
            break label_4;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:{
            jj_consume_token(WHITESPACE);
            break;
            }
          case NEWLINE:{
            jj_consume_token(NEWLINE);
            break;
            }
          default:
            jj_la1[38] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        TypeParam(true);
        label_5:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:
          case NEWLINE:
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[39] = jj_gen;
            break label_5;
          }
          label_6:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WHITESPACE:
            case NEWLINE:{
              ;
              break;
              }
            default:
              jj_la1[40] = jj_gen;
              break label_6;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WHITESPACE:{
              jj_consume_token(WHITESPACE);
              break;
              }
            case NEWLINE:{
              jj_consume_token(NEWLINE);
              break;
              }
            default:
              jj_la1[41] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          jj_consume_token(COMMA);
          label_7:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WHITESPACE:
            case NEWLINE:{
              ;
              break;
              }
            default:
              jj_la1[42] = jj_gen;
              break label_7;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WHITESPACE:{
              jj_consume_token(WHITESPACE);
              break;
              }
            case NEWLINE:{
              jj_consume_token(NEWLINE);
              break;
              }
            default:
              jj_la1[43] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          TypeParam(true);
        }
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      default:
        jj_la1[45] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case GT:{
        jj_consume_token(GT);
wellFormed = true;
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setWellFormed(wellFormed);
    return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ChunkerTypeParam TypeParam(boolean canWildcard) throws ParseException {/*@bgen(jjtree) TypeParam */
  ChunkerTypeParam jjtn000 = new ChunkerTypeParam(this, JJTTYPEPARAM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));boolean wellFormed=false;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ID:{
        jj_consume_token(ID);
        label_8:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:
          case NEWLINE:{
            ;
            break;
            }
          default:
            jj_la1[47] = jj_gen;
            break label_8;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:{
            jj_consume_token(WHITESPACE);
            break;
            }
          case NEWLINE:{
            jj_consume_token(NEWLINE);
            break;
            }
          default:
            jj_la1[48] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        label_9:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ACCESS:{
            ;
            break;
            }
          default:
            jj_la1[49] = jj_gen;
            break label_9;
          }
          jj_consume_token(ACCESS);
          label_10:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WHITESPACE:
            case NEWLINE:{
              ;
              break;
              }
            default:
              jj_la1[50] = jj_gen;
              break label_10;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WHITESPACE:{
              jj_consume_token(WHITESPACE);
              break;
              }
            case NEWLINE:{
              jj_consume_token(NEWLINE);
              break;
              }
            default:
              jj_la1[51] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ID:{
            jj_consume_token(ID);
            break;
            }
          default:
            jj_la1[52] = jj_gen;
            ;
          }
          label_11:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WHITESPACE:
            case NEWLINE:{
              ;
              break;
              }
            default:
              jj_la1[53] = jj_gen;
              break label_11;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case WHITESPACE:{
              jj_consume_token(WHITESPACE);
              break;
              }
            case NEWLINE:{
              jj_consume_token(NEWLINE);
              break;
              }
            default:
              jj_la1[54] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        break;
        }
      case QUEST:{
        jj_consume_token(QUEST);
if (!canWildcard) {
        report(MALFORMED_TYPE_ARGUMENT);
      }
        break;
        }
      default:
        jj_la1[55] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:
      case NEWLINE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:{
          jj_consume_token(WHITESPACE);
          break;
          }
        case NEWLINE:{
          jj_consume_token(NEWLINE);
          break;
          }
        default:
          jj_la1[56] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[57] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EXTENDS:
      case SUPER:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EXTENDS:{
          jj_consume_token(EXTENDS);
          break;
          }
        case SUPER:{
          jj_consume_token(SUPER);
          break;
          }
        default:
          jj_la1[58] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:{
            jj_consume_token(WHITESPACE);
            break;
            }
          case NEWLINE:{
            jj_consume_token(NEWLINE);
            break;
            }
          default:
            jj_la1[59] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[60] = jj_gen;
          ;
        }
        jj_consume_token(ID);
        label_12:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ACCESS:{
            ;
            break;
            }
          default:
            jj_la1[61] = jj_gen;
            break label_12;
          }
          jj_consume_token(ACCESS);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ID:{
            jj_consume_token(ID);
            break;
            }
          default:
            jj_la1[62] = jj_gen;
            ;
          }
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LT:{
          TypeParams();
          break;
          }
        default:
          jj_la1[63] = jj_gen;
          ;
        }
        label_13:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case AMP:{
            ;
            break;
            }
          default:
            jj_la1[64] = jj_gen;
            break label_13;
          }
          jj_consume_token(AMP);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ID:{
            jj_consume_token(ID);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case LT:{
              TypeParams();
              break;
              }
            default:
              jj_la1[65] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[66] = jj_gen;
            ;
          }
        }
        break;
        }
      default:
        jj_la1[67] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setWellFormed(wellFormed);
    return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ChunkerIdent Ident() throws ParseException {/*@bgen(jjtree) Ident */
  ChunkerIdent jjtn000 = new ChunkerIdent(this, JJTIDENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(ID);
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
return jjtn000;
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
}

  final public ChunkerNum Num() throws ParseException {/*@bgen(jjtree) Num */
  ChunkerNum jjtn000 = new ChunkerNum(this, JJTNUM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(NUM);
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
return jjtn000;
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
}

  final public ChunkerWhitespace Whitespace() throws ParseException {/*@bgen(jjtree) Whitespace */
  ChunkerWhitespace jjtn000 = new ChunkerWhitespace(this, JJTWHITESPACE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(WHITESPACE);
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
return jjtn000;
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
}

  final public ChunkerMethodName MethodName() throws ParseException {/*@bgen(jjtree) MethodName */
  ChunkerMethodName jjtn000 = new ChunkerMethodName(this, JJTMETHODNAME);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(INVOKE);
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
return jjtn000;
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
}

  final public ChunkerNewline Newline() throws ParseException {/*@bgen(jjtree) Newline */
  ChunkerNewline jjtn000 = new ChunkerNewline(this, JJTNEWLINE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(NEWLINE);
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
return jjtn000;
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
}

  final public ChunkerNew New() throws ParseException {/*@bgen(jjtree) New */
ChunkerNew jjtn000 = new ChunkerNew(this, JJTNEW);
boolean jjtc000 = true;
jjtree.openNodeScope(jjtn000);
jjtreeOpenNodeScope(jjtn000);
jjtn000.jjtSetFirstToken(getToken(1));boolean wellFormed = false;
String name = null;
ChunkerInvokable parent = invoker;
List<IsScope> scope = null;
    try {
      jj_consume_token(NEW);
      jj_consume_token(WHITESPACE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:{
        TypeParams();
        break;
        }
      default:
        jj_la1[68] = jj_gen;
        ;
      }
      if (jj_2_7(1)) {
        scope = Scope();
jjtn000.addScope(scope);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      default:
        jj_la1[69] = jj_gen;
        ;
      }
      if (jj_2_9(1)) {
        if (isTypedInvoke(true)) {
          jj_consume_token(ID);
name = token.image;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:{
            jj_consume_token(WHITESPACE);
            break;
            }
          default:
            jj_la1[70] = jj_gen;
            ;
          }
          TypeParams();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:{
            jj_consume_token(WHITESPACE);
            break;
            }
          default:
            jj_la1[71] = jj_gen;
            ;
          }
          MethodName();
name += "." + token.image.substring(0, token.image.length()-1);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case INVOKE:{
            MethodName();
// shave off the opening (
         name = token.image.substring(0, token.image.length()-1);
            break;
            }
          default:
            jj_la1[72] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:{
          Whitespace();
          break;
          }
        default:
          jj_la1[73] = jj_gen;
          ;
        }
invoker = jjtn000;
        if (jj_2_8(1)) {
          MethodArguments(jjtn000);
        } else {
          ;
        }
invoker = parent;
        try {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case CLOSE_PAREN:{
            jj_consume_token(CLOSE_PAREN);
wellFormed = true;
            break;
            }
          case NEWLINE:{
            Newline();
// we want to let newline end the final statement of source,
          // but we don't actually want to keep the token; that will be needed
          // to finish a not-the-last statement in a block of source.
          jjtn000.setWellFormed(false);
          putBackTokens(true);
          token.next = null;
          jjtree.popNode();
            break;
            }
          case 0:{
            Eof();
wellFormed = false;
            break;
            }
          default:
            jj_la1[74] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        } catch (ParseException e) {
// This invocation is malformed; recover here so we can continue
       Node node = jjtree.nodeArity() > 0 ? jjtree.peekNode() : jjtn000;
       Token junk = eatJunk();
       node.addToken(junk);
        }
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
if (name == null) { wellFormed = false; }
  jjtn000.setName(name);
  jjtn000.setWellFormed(wellFormed);
  return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Node maybeBin(Node src) throws ParseException {ChunkerBinaryExpression result;
      assert src == jjtree.peekNode();
      jjtree.popNode();
    result = BinaryExpression(src);
if (result.getJoiner() == null && result.getRight() == null) {
      jjtree.pushNode(src);
      return src;
    }
    return result.rescope(null);
}

// Forms a chain of whitespace-separated values;
// anything that actually matches in here is likely either
// malformed, or deserving of it's own production
// (but, for now, we're being extremely lax, so
// the parser can at least survive valid source that it
// simply does not understand well enough yet).
  final public Node Values() throws ParseException {Node value;
  ChunkerWhitespace ws = null;
    value = Expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case WHITESPACE:{
      ws = Whitespace();
jjtree.popNode();
      break;
      }
    default:
      jj_la1[75] = jj_gen;
      ;
    }
    label_14:
    while (true) {
      if (jj_2_10(1)) {
        ;
      } else {
        break label_14;
      }
      value = maybeBin(value);
if (ws != null) {
          value.insertChild(ws, 1);
          ws = null;
        }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        ws = Whitespace();
jjtree.popNode();
        break;
        }
      default:
        jj_la1[76] = jj_gen;
        ;
      }
    }
if (ws != null) {
      jjtree.pushNode(ws);
    }
    return value;
}

  final public Node MethodArg() throws ParseException {Node value;
    if (isPythonAnnotated()) {
      value = Ident();
      jj_consume_token(COLON);
value.addToken(token);
    } else if (jj_2_11(1)) {
      value = Values();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return value;
}

  final public void MethodArguments(ChunkerInvokable invokable) throws ParseException {Node value; ChunkerAssign assign;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STARS:{
      jj_consume_token(STARS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        Whitespace();
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[78] = jj_gen;
      ;
    }
    value = MethodArg();
invokable.addArgument(value);
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:
      case NEWLINE:{
        ;
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        break label_15;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        Whitespace();
        break;
        }
      case NEWLINE:{
        Newline();
        break;
        }
      default:
        jj_la1[80] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if (isAssign()) {
      assign = Assign();
      if (jj_2_12(1)) {
        value = Values();
assign.setValue(value);
      } else {
        ;
      }
    } else {
      ;
    }
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:
      case NEWLINE:{
        ;
        break;
        }
      default:
        jj_la1[81] = jj_gen;
        break label_16;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        Whitespace();
        break;
        }
      case NEWLINE:{
        Newline();
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[83] = jj_gen;
        break label_17;
      }
      jj_consume_token(COMMA);
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:{
          ;
          break;
          }
        default:
          jj_la1[84] = jj_gen;
          break label_18;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:{
          Whitespace();
          break;
          }
        case NEWLINE:{
          Newline();
          break;
          }
        default:
          jj_la1[85] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STARS:{
        jj_consume_token(STARS);
        break;
        }
      default:
        jj_la1[86] = jj_gen;
        ;
      }
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:{
          ;
          break;
          }
        default:
          jj_la1[87] = jj_gen;
          break label_19;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:{
          Whitespace();
          break;
          }
        case NEWLINE:{
          Newline();
          break;
          }
        default:
          jj_la1[88] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_13(1)) {
        value = MethodArg();
invokable.addArgument(value);
        label_20:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:
          case NEWLINE:{
            ;
            break;
            }
          default:
            jj_la1[89] = jj_gen;
            break label_20;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:{
            Whitespace();
            break;
            }
          case NEWLINE:{
            Newline();
            break;
            }
          default:
            jj_la1[90] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        ;
      }
    }
}

  final public List<IsScope> Scope() throws ParseException {ChunkerIdent addTo;
  ChunkerTypeParams typeParams;
  List<IsScope> sub, result = new ArrayList();
    if (isScope()) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    addTo = Ident();
// hm, should probably pop this node, and force callers to always stash the actual nodes on something.
       result.add(addTo);
       jjtree.popNode();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LT:{
      typeParams = TypeParams();
addTo.setTypeParams(typeParams);
        // we are eating these TypeParams, so remove them from the stack.
        jjtree.popNode();
      break;
      }
    default:
      jj_la1[91] = jj_gen;
      ;
    }
    jj_consume_token(ACCESS);
// add this to the Ident that we'll be returning.
        // We should maybe have a different subtype for this...
        addTo.addToken(token);
    if (jj_2_14(1)) {
      sub = Scope();
result.addAll(sub);
    } else {
      ;
    }
return result;
}

  final public List<ChunkerAnnotation> Annotations() throws ParseException {ChunkerAnnotation anno;
  List<ChunkerAnnotation> result = new ArrayList();
    label_21:
    while (true) {
      anno = Annotation();
result.add(anno);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[92] = jj_gen;
        break label_21;
      }
    }
return result;
}

  final public ChunkerAnnotation Annotation() throws ParseException {/*@bgen(jjtree) Annotation */
  ChunkerAnnotation jjtn000 = new ChunkerAnnotation(this, JJTANNOTATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));boolean wellFormed = false;
    try {
      jj_consume_token(AT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ID:{
        Ident();
wellFormed = true;
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        Whitespace();
        break;
        }
      default:
        jj_la1[94] = jj_gen;
        ;
      }
      if (jj_2_15(1)) {
        Invoke();
      } else {
        ;
      }
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:{
          ;
          break;
          }
        default:
          jj_la1[95] = jj_gen;
          break label_22;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:{
          Whitespace();
          break;
          }
        case NEWLINE:{
          Newline();
          break;
          }
        default:
          jj_la1[96] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ChunkerInvoke Invoke() throws ParseException {/*@bgen(jjtree) Invoke */
  ChunkerInvoke jjtn000 = new ChunkerInvoke(this, JJTINVOKE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));boolean wellFormed = false;
  String name;
  ChunkerInvokable parent = invoker;
    try {
      if (isTypedInvoke(false)) {
        TypeParams();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:{
          jj_consume_token(WHITESPACE);
          break;
          }
        default:
          jj_la1[97] = jj_gen;
          ;
        }
        MethodName();
name = token.image.substring(0, token.image.length()-1);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case INVOKE:{
          MethodName();
// shave off the opening (
      name = token.image.substring(0, token.image.length()-1);
          break;
          }
        default:
          jj_la1[98] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      label_23:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:{
          ;
          break;
          }
        default:
          jj_la1[99] = jj_gen;
          break label_23;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:{
          Whitespace();
          break;
          }
        case NEWLINE:{
          Newline();
          break;
          }
        default:
          jj_la1[100] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
invoker = jjtn000;
      if (jj_2_16(1)) {
        MethodArguments(jjtn000);
      } else {
        ;
      }
if (parent != null) {
   //   jjtThis.addScope(parent);
    }
    invoker = parent;
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CLOSE_PAREN:{
          jj_consume_token(CLOSE_PAREN);
wellFormed = true;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:{
            jj_consume_token(WHITESPACE);
            break;
            }
          default:
            jj_la1[101] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ARROW:{
            jj_consume_token(ARROW);
            if (jj_2_17(1)) {
              Values();
            } else {
              ;
            }
wellFormed = false;
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case COLON:{
              jj_consume_token(COLON);
wellFormed = true;
              break;
              }
            default:
              jj_la1[102] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[103] = jj_gen;
            ;
          }
          break;
          }
        case NEWLINE:{
          Newline();
// we want to let newline end the final statement of source,
        // but we don't actually want to keep the token; that will be needed
        // to finish a not-the-last statement in a block of source.
        jjtn000.setWellFormed(false);
          break;
          }
        case 0:{
          Eof();
wellFormed = false;
          break;
          }
        default:
          jj_la1[104] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (ParseException e) {
// This invocation is malformed; recover here so we can continue
     Node node = jjtree.nodeArity() > 0 ? jjtree.peekNode() : jjtn000;
     Token junk = eatJunk();
     node.addToken(junk);
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setWellFormed(wellFormed);
      jjtn000.setName(name);
      return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ChunkerParam Param() throws ParseException {/*@bgen(jjtree) Param */
  ChunkerParam jjtn000 = new ChunkerParam(this, JJTPARAM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));List<IsScope> scope;
  Node value; ChunkerAssign assign;
    try {
      if (isScope()) {
        scope = Scope();
for (IsScope ident : scope) {
          jjtn000.addChild(ident);
        }
      } else {
        ;
      }
      Ident();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      default:
        jj_la1[105] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        Values();
        break;
        }
      default:
        jj_la1[106] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:{
        TypeParams();
        break;
        }
      default:
        jj_la1[107] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      default:
        jj_la1[108] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ARRAY_START:{
        Array();
        break;
        }
      default:
        jj_la1[109] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        if (jj_2_20(1)) {
          if (jj_2_19(1)) {
            if (isAssign()) {

            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
            // try to gobble up assigns first...
                       assign = Assign();
            label_24:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case WHITESPACE:
              case NEWLINE:{
                ;
                break;
                }
              default:
                jj_la1[110] = jj_gen;
                break label_24;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case WHITESPACE:{
                jj_consume_token(WHITESPACE);
                break;
                }
              case NEWLINE:{
                jj_consume_token(NEWLINE);
                break;
                }
              default:
                jj_la1[111] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
            if (jj_2_18(1)) {
              value = Expression();
assign.setValue(value);
            } else {
              ;
            }
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case ID:{
              Ident();
              break;
              }
            default:
              jj_la1[112] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        } else {
          ;
        }
        break;
        }
      default:
        jj_la1[113] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      default:
        jj_la1[114] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ChunkerClosure Closure() throws ParseException {/*@bgen(jjtree) Closure */
  ChunkerClosure jjtn000 = new ChunkerClosure(this, JJTCLOSURE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));boolean wellFormed = false, hasType = false, hadComma = false;
  Node n = null;
  List<IsScope> scope;
  List<ChunkerParam> params;
    try {
      jj_consume_token(CLOSURE_START);
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:{
          ;
          break;
          }
        default:
          jj_la1[115] = jj_gen;
          break label_25;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:{
          Whitespace();
          break;
          }
        case NEWLINE:{
          Newline();
          break;
          }
        default:
          jj_la1[116] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (isParamList()) {
        n = ClosureParams();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ARROW:{
          jj_consume_token(ARROW);
          break;
          }
        default:
          jj_la1[117] = jj_gen;
          ;
        }
      } else {
        ;
      }
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:{
          ;
          break;
          }
        default:
          jj_la1[118] = jj_gen;
          break label_26;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:{
          Whitespace();
          break;
          }
        case NEWLINE:{
          Newline();
          break;
          }
        default:
          jj_la1[119] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      EatStatements(false);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:{
          ;
          break;
          }
        default:
          jj_la1[120] = jj_gen;
          break label_27;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:{
          Whitespace();
          break;
          }
        case NEWLINE:{
          Newline();
          break;
          }
        default:
          jj_la1[121] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CLOSURE_END:{
          jj_consume_token(CLOSURE_END);
wellFormed = true;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:{
            Whitespace();
jjtree.popNode();
            break;
            }
          default:
            jj_la1[122] = jj_gen;
            ;
          }
          if (jj_2_21(1)) {
            Invoke();
          } else {
            ;
          }
          break;
          }
        case 0:{
          Eof();
jjtn000.setWellFormed(false);
          break;
          }
        default:
          jj_la1[123] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (ParseException e) {
// This invocation is malformed; recover here so we can continue
     Node node = jjtree.nodeArity() > 0 ? jjtree.peekNode() : jjtn000;
     Token junk = eatJunk();
     node.addToken(junk);
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setWellFormed(wellFormed);
      return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Node ClosureParams() throws ParseException {Node n = null;
    try {
      n = Param();
      label_28:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[124] = jj_gen;
          break label_28;
        }
        jj_consume_token(COMMA);
        label_29:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:
          case NEWLINE:{
            ;
            break;
            }
          default:
            jj_la1[125] = jj_gen;
            break label_29;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:{
            jj_consume_token(WHITESPACE);
            break;
            }
          case NEWLINE:{
            jj_consume_token(NEWLINE);
            break;
            }
          default:
            jj_la1[126] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        n = Param();
      }
    } catch (ParseException ignored) {

    }
return n;
}

  final public ChunkerArray Array() throws ParseException {/*@bgen(jjtree) Array */
  ChunkerArray jjtn000 = new ChunkerArray(this, JJTARRAY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));boolean wellFormed = false;
  Node n = null;
    try {
      jj_consume_token(ARRAY_START);
      label_30:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:{
          ;
          break;
          }
        default:
          jj_la1[127] = jj_gen;
          break label_30;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:{
          Whitespace();
          break;
          }
        case NEWLINE:{
          Newline();
          break;
          }
        default:
          jj_la1[128] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_22(1)) {
        MethodArguments(jjtn000);
      } else {
        ;
      }
      label_31:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:
        case NEWLINE:{
          ;
          break;
          }
        default:
          jj_la1[129] = jj_gen;
          break label_31;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case WHITESPACE:{
          Whitespace();
          break;
          }
        case NEWLINE:{
          Newline();
          break;
          }
        default:
          jj_la1[130] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ARRAY_END:{
          jj_consume_token(ARRAY_END);
wellFormed = true;
          break;
          }
        case 0:{
          Eof();
wellFormed = false;
          break;
          }
        default:
          jj_la1[131] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (ParseException e) {
// This invocation is malformed; recover here so we can continue
     Node node = jjtree.nodeArity() > 0 ? jjtree.peekNode() : jjtn000;
     Token junk = eatJunk();
     node.addToken(junk);
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
jjtn000.setWellFormed(wellFormed);
      return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public Node Expression() throws ParseException {Node expr = null, expr2 = null, anchor = null;
    String name;
    ChunkerBinaryExpression bin = null;
    ChunkerWhitespace ws = null;
    ChunkerAssign assign = null;
    boolean wellFormed = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CLOSURE_START:{
      expr = Closure();
      break;
      }
    case ARRAY_START:{
      expr = Array();
      break;
      }
    default:
      jj_la1[133] = jj_gen;
      if (jj_2_24(1)) {
        expr = Invoke();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case QUOTE:
        case APOS:{
          expr = String();
          break;
          }
        case NUM:{
          expr = Num();
          break;
          }
        case NEW:{
          expr = New();
          break;
          }
        case ID:{
          expr = Ident();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case WHITESPACE:{
            ws = Whitespace();
jjtree.popNode();
            if (jj_2_23(1)) {
              expr2 = Expression();
ChunkerBinaryExpression b = new ChunkerBinaryExpression(this, JJTBINARYEXPRESSION);
             jjtree.popNode();
             jjtree.popNode();
             b.setLeft(expr);
             b.insertChild(ws, 1);
             b.setJoiner(ws.jjtGetFirstToken());
             b.setRight(expr2);
             expr = b.rescope(null);
             jjtree.pushNode(expr);
            } else {
              ;
            }
            break;
            }
          default:
            jj_la1[132] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[134] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case WHITESPACE:{
      ws = Whitespace();
jjtree.popNode();
      break;
      }
    default:
      jj_la1[135] = jj_gen;
      ;
    }
    if (jj_2_25(1)) {
jjtree.popNode();
      bin = BinaryExpression(expr);
if (bin.getRight() == null && bin.getJoiner() == null) {
          if (ws != null) {
            jjtree.pushNode(ws);
          }
          bin = null;
        } else {
          if (ws != null) {
            bin.insertChild(ws, 1);
          }
          expr = bin.rescope(null);
          if (bin != expr) {
            jjtree.popNode();
            jjtree.pushNode(expr);
            bin = null;
          }
        }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASSIGN:{
      jj_consume_token(ASSIGN);
// If we saw an assign statement, then we need to make the current expression the scope of an Assign().
          assign = new ChunkerAssign(this, JJTASSIGN);
          jjtree.popNode();
          assign.addChild(bin == null ? expr : bin);
          bin = null;
          if (ws != null) {
            assign.addChild(ws);
          }
          assign.addToken(token);
          jjtree.pushNode(assign);
          expr = assign;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
assign.addToken(token);
        break;
        }
      default:
        jj_la1[136] = jj_gen;
        ;
      }
      if (jj_2_26(1)) {
        expr2 = Values();
assign.setValue(expr2);
        jjtree.popNode();
        assign.addChild(expr2);
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[137] = jj_gen;
      ;
    }
if (assign != null) {
    // TODO: make addChild fix tokens so we can delete this workaround
    assign.jjtSetLastToken(token);
  }
  return bin == null ? expr : bin;
}

  final public void EatBinaryWhitespace() throws ParseException {
    if (isBinExprAcrossNewline()) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      case NEWLINE:{
        jj_consume_token(NEWLINE);
        break;
        }
      default:
        jj_la1[138] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:
      case NEWLINE:{
        ;
        break;
        }
      default:
        jj_la1[139] = jj_gen;
        break label_32;
      }
    }

}

  final public ChunkerBinaryExpression BinaryExpression(Node left) throws ParseException {/*@bgen(jjtree) BinaryExpression */
  ChunkerBinaryExpression jjtn000 = new ChunkerBinaryExpression(this, JJTBINARYEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));boolean wellFormed = left.isWellFormed();
  Node right = null;
  Token joiner;
  jjtn000.setLeft(left);
//  jjtree.popNode();

    try {
      if (jj_2_27(1)) {
        EatBinaryWhitespace();
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LOGIC:{
        jj_consume_token(LOGIC);
if (!(token.image.equals("++") || token.image.equals("--"))) {
          wellFormed = false; // if there is an expression, it will be reset to true...
        }
        joiner = token;
        jjtn000.setJoiner(joiner);
        break;
        }
      case ACCESS:{
        jj_consume_token(ACCESS);
wellFormed = false; // not legal to have this w/out a followup expression
        joiner = token;
        jjtn000.setJoiner(joiner);
        break;
        }
      case STARS:{
        jj_consume_token(STARS);
wellFormed = false; // not legal to have this w/out a followup expression
        joiner = token;
        jjtn000.setJoiner(joiner);
        break;
        }
      case DOUBLE_EQ:{
        jj_consume_token(DOUBLE_EQ);
wellFormed = false; // not legal to have this w/out a followup expression
        joiner = token;
        jjtn000.setJoiner(joiner);
        break;
        }
      case AMP:{
        jj_consume_token(AMP);
wellFormed = false; // not legal to have this w/out a followup expression
        joiner = token;
        jjtn000.setJoiner(joiner);
        break;
        }
      case GT:{
        jj_consume_token(GT);
wellFormed = false; // not legal to have this w/out a followup expression
        joiner = token;
        jjtn000.setJoiner(joiner);
        break;
        }
      case LT:{
        jj_consume_token(LT);
wellFormed = false; // not legal to have this w/out a followup expression
        joiner = token;
        jjtn000.setJoiner(joiner);
        break;
        }
      case ID:{
        jj_consume_token(ID);
joiner = token;
        jjtn000.setJoiner(joiner);
        break;
        }
      case COLON:{
        jj_consume_token(COLON);
joiner = token;
        jjtn000.setJoiner(joiner);
        break;
        }
      case ARRAY_START:{
        right = Array();
ChunkerBinaryExpression b = new ChunkerBinaryExpression(this, JJTBINARYEXPRESSION);
        jjtree.popNode();
        b.setLeft(left);
        // no joiner when we're mashing a trailing [] onto an expression (optional parens are troublesome)
        b.setRight(right);
        left = b;
        right = null;
        jjtn000.setLeft(b);
        wellFormed = left.isWellFormed();
        break;
        }
      default:
        jj_la1[140] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      default:
        jj_la1[141] = jj_gen;
        ;
      }
      if (jj_2_28(1)) {
        right = Expression();
wellFormed = left.isWellFormed();
      jjtn000.setRight(right);
      Node maybeWs = jjtree.popNode();
      if (maybeWs instanceof ChunkerWhitespace) {
        Node next = jjtree.popNode();
        assert next == right;
        jjtree.pushNode(maybeWs);
      }
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case WHITESPACE:{
        jj_consume_token(WHITESPACE);
        break;
        }
      default:
        jj_la1[142] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
  jjtc000 = false;
  if (jjtree.nodeCreated()) {
   jjtreeCloseNodeScope(jjtn000);
  }
  jjtn000.jjtSetLastToken(getToken(0));
// TODO: transform <ASSIGN> types to scopes...
    jjtn000.setWellFormed(wellFormed);
    return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

  final public ChunkerString String() throws ParseException {/*@bgen(jjtree) String */
ChunkerString jjtn000 = new ChunkerString(this, JJTSTRING);
boolean jjtc000 = true;
jjtree.openNodeScope(jjtn000);
jjtreeOpenNodeScope(jjtn000);
jjtn000.jjtSetFirstToken(getToken(1));boolean wellFormed = false;
StringBuilder b = new StringBuilder();
String quoteType;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case QUOTE:{
        jj_consume_token(QUOTE);
quoteType = token.image;
        wellFormed = false;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 0:
        case QUOTE_BODY:
        case QUOTE_CLOSE:
        case NEWLINE:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case QUOTE_BODY:{
            jj_consume_token(QUOTE_BODY);
b.append(token.image);
            break;
            }
          default:
            jj_la1[143] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NEWLINE:{
            Newline();
// TODO: take a parameter to this production that controls
            // whether we simply absorb the newlines, or form a malformed ast node.
            jjtn000.setWellFormed(false);
            jjtree.popNode();
            putBackTokens(true);
            token.next = null;
            break;
            }
          case 0:{
            Eof();
wellFormed = false;
            jjtree.popNode();
            break;
            }
          case QUOTE_CLOSE:{
            jj_consume_token(QUOTE_CLOSE);
wellFormed = "\"".equals(token.image);
            if (!wellFormed) {
              back(token.image.length(), -1);
            }
            break;
            }
          default:
            jj_la1[144] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[145] = jj_gen;
          ;
        }
        break;
        }
      case APOS:{
        jj_consume_token(APOS);
quoteType = token.image;
wellFormed = false;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 0:
        case APOS_BODY:
        case APOS_CLOSE:
        case NEWLINE:{
          label_33:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case APOS_BODY:{
              ;
              break;
              }
            default:
              jj_la1[146] = jj_gen;
              break label_33;
            }
            jj_consume_token(APOS_BODY);
b.append(token.image);
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NEWLINE:{
            Newline();
// TODO: take a parameter to this production that controls
           // whether we simply absorb the newlines, or form a malformed ast node.
           jjtn000.setWellFormed(false);
           jjtree.popNode();
           putBackTokens(true);
           token.next = null;
            break;
            }
          case 0:{
            Eof();
wellFormed = false;
           jjtree.popNode();
            break;
            }
          case APOS_CLOSE:{
            jj_consume_token(APOS_CLOSE);
wellFormed = "'".equals(token.image);
           if (!wellFormed) {
             back(token.image.length(), -1);
           }
            break;
            }
          default:
            jj_la1[147] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[148] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[149] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
jjtn000.initialize(quoteType, b.toString(), wellFormed);
    return jjtn000;
    } catch (Throwable jjte000) {
if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
}

// This is here so we can easily Eof() { jjtree.popNode(); } to discard eof tokens
  final public ChunkerEof Eof() throws ParseException {/*@bgen(jjtree) Eof */
  ChunkerEof jjtn000 = new ChunkerEof(this, JJTEOF);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtreeOpenNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(0);
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    if (jjtree.nodeCreated()) {
     jjtreeCloseNodeScope(jjtn000);
    }
    jjtn000.jjtSetLastToken(getToken(0));
return jjtn000;
    } finally {
if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      if (jjtree.nodeCreated()) {
       jjtreeCloseNodeScope(jjtn000);
      }
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_3_6()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(22)) jj_scanpos = xsp;
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_59()
 {
    if (jj_scan_token(STARS)) return true;
    return false;
  }

  private boolean jj_3R_56()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_39()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_59()) jj_scanpos = xsp;
    if (jj_3R_43()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_94()
 {
    if (jj_scan_token(APOS)) return true;
    return false;
  }

  private boolean jj_3R_55()
 {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_54()
 {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_61()
 {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_53()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_43()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = isPythonAnnotated();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3_11()) return true;
    }
    return false;
  }

  private boolean jj_3R_36()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_53()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = isTypedAssign();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_54()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isAssign();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_55()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isClassDecl();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3_6()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3R_93()
 {
    if (jj_scan_token(QUOTE)) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_42()) return true;
    return false;
  }

  private boolean jj_3R_88()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) return true;
    }
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3R_69()
 {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_35()
 {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_68()
 {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_92()
 {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_67()
 {
    if (jj_3R_89()) return true;
    return false;
  }

  private boolean jj_3R_66()
 {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_37()
 {
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_34()
 {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_65()
 {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3_2()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_3R_92()) return true;
    return false;
  }

  private boolean jj_3R_64()
 {
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_45()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_47()
 {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_42()
 {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3R_63()
 {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_62()
 {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_44()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = isTypedInvoke(false);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    }
    return false;
  }

  private boolean jj_3R_76()
 {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3R_75()
 {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_scan_token(ARRAY_START)) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    if (jj_scan_token(AMP)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3R_95()
 {
    if (jj_scan_token(AT)) return true;
    return false;
  }

  private boolean jj_3R_73()
 {
    if (jj_scan_token(DOUBLE_EQ)) return true;
    return false;
  }

  private boolean jj_3R_41()
 {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_72()
 {
    if (jj_scan_token(STARS)) return true;
    return false;
  }

  private boolean jj_3R_91()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_71()
 {
    if (jj_scan_token(ACCESS)) return true;
    return false;
  }

  private boolean jj_3R_82()
 {
    Token xsp;
    if (jj_3R_91()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_91()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_40()
 {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_70()
 {
    if (jj_scan_token(LOGIC)) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = isTypedInvoke(true);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) return true;
    }
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    if (jj_scan_token(NEW)) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_49()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_27()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_80()
 {
    return false;
  }

  private boolean jj_3R_51()
 {
    if (jj_scan_token(NEWLINE)) return true;
    return false;
  }

  private boolean jj_3R_57()
 {
    return false;
  }

  private boolean jj_3R_81()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) return true;
    }
    return false;
  }

  private boolean jj_3R_50()
 {
    jj_lookingAhead = true;
    jj_semLA = isBinExprAcrossNewline();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_80()) return true;
    Token xsp;
    if (jj_3R_81()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_81()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_60()
 {
    if (jj_scan_token(INVOKE)) return true;
    return false;
  }

  private boolean jj_3R_38()
 {
    jj_lookingAhead = true;
    jj_semLA = isScope();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_57()) return true;
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_52()
 {
    if (jj_scan_token(WHITESPACE)) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_scan_token(CLOSURE_START)) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_89()
 {
    if (jj_scan_token(NUM)) return true;
    return false;
  }

  private boolean jj_3R_46()
 {
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_43()) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_58()
 {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) return true;
    }
    return false;
  }

  private boolean jj_3_19()
 {
    jj_lookingAhead = true;
    jj_semLA = isAssign();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_46()) return true;
    if (jj_3R_47()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ChunkerTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[150];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x3000,0x1000,0x0,0x400000,0x1000,0x1000,0x10001000,0x1000,0x2001,0x1000,0x1000,0x1000,0x1000,0x10000000,0x1000,0x1000,0x1000000,0x1000,0x1000,0x1000,0x10000000,0x1000,0x1000,0x2000000,0x10000000,0x1000,0x1000,0x0,0x1,0x1,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x0,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x10003000,0x1000,0x0,0x3000,0x3000,0x0,0x3000,0x3000,0x10000000,0x3000,0x3000,0x10000000,0x3000,0x3000,0x9000000,0x3000,0x3000,0x0,0x10000000,0x0,0x0,0x0,0x10000000,0x9000000,0x0,0x1000,0x1000,0x1000,0x0,0x1000,0x2001,0x1000,0x1000,0x1000,0x0,0x3000,0x3000,0x3000,0x3000,0x0,0x3000,0x3000,0x0,0x3000,0x3000,0x3000,0x3000,0x0,0x0,0x10000000,0x1000,0x3000,0x3000,0x1000,0x0,0x3000,0x3000,0x1000,0x0,0x0,0x2001,0x1000,0x0,0x0,0x1000,0x0,0x3000,0x3000,0x10000000,0x1000,0x1000,0x3000,0x3000,0x0,0x3000,0x3000,0x3000,0x3000,0x1000,0x1,0x0,0x3000,0x3000,0x3000,0x3000,0x3000,0x3000,0x1,0x1000,0x0,0x90b00000,0x1000,0x1000,0x0,0x3000,0x3000,0x10000000,0x1000,0x1000,0x400,0x2801,0x2c01,0x80,0x2101,0x2181,0x300000,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x300070,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x2000,0x0,0x1000,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x800,0x4000,0x800,0x0,0x0,0x800,0x0,0x0,0x0,0x8,0x0,0x400000,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x800,0x80,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x20,0x400,0x400000,0x0,0x20,0x800,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x40,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x110,0x0,0x0,0x0,0x4,0x0,0x0,0x3d922,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[28];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public Chunker(Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new ChunkerTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 150; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public Chunker(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new ChunkerTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 150; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public Chunker(ChunkerTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 150; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ChunkerTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 150; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = jj_lookingAhead ? jj_scanpos : token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[55];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 150; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 55; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : ChunkerTokenManager.lexStateNames[token_source.curLexState]);
  }

  private int trace_indent = 0;
  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 28; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			   case 8: jj_3_9(); break;
			   case 9: jj_3_10(); break;
			   case 10: jj_3_11(); break;
			   case 11: jj_3_12(); break;
			   case 12: jj_3_13(); break;
			   case 13: jj_3_14(); break;
			   case 14: jj_3_15(); break;
			   case 15: jj_3_16(); break;
			   case 16: jj_3_17(); break;
			   case 17: jj_3_18(); break;
			   case 18: jj_3_19(); break;
			   case 19: jj_3_20(); break;
			   case 20: jj_3_21(); break;
			   case 21: jj_3_22(); break;
			   case 22: jj_3_23(); break;
			   case 23: jj_3_24(); break;
			   case 24: jj_3_25(); break;
			   case 25: jj_3_26(); break;
			   case 26: jj_3_27(); break;
			   case 27: jj_3_28(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
