/* Generated By:JJTree: Do not edit this line. SimpleNode.java Version 7.0 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=true,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=Chunker,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package io.deephaven.lang.generated;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public
class SimpleNode implements Node {

  protected Node parent;
  protected Node[] children;
  protected int id;
  protected Object value;
  protected Chunker parser;
  protected Token firstToken;
  protected Token lastToken;
  private boolean wellFormed;
  private Token junk;

  public SimpleNode(int i) {
    id = i;
  }

  public SimpleNode(Chunker p, int i) {
    this(i);
    parser = p;
  }

  public void jjtOpen() {
  }

  public void jjtClose() {
  }

  public void jjtSetParent(Node n) {
    assert n != this;
    assert n.jjtGetParent() != this : "Cannot make a child our parent";
    assert this.indexOf(n) == -1 : "Cannot make a child our parent";
    parent = n;
  }
  public Node jjtGetParent() {
    return parent;
  }

  public void jjtAddChild(Node n, int i) {
    assert n != this;
    assert this == n.jjtGetParent() : "Set the parent of a node before adding it as a child!";
    assert n != jjtGetParent();
    if (children == null) {
      children = new Node[i + 1];
    } else if (i >= children.length) {
      Node c[] = new Node[i + 1];
      System.arraycopy(children, 0, c, 0, children.length);
      children = c;
    }
    assert Arrays.stream(children).noneMatch(n::equals) : "Do not double-add " + n + " to " + this;
    children[i] = n;
  }
  public void jjtInsertChild(Node n, int i) {
    assert n != this;
    assert this == n.jjtGetParent() : "Set the parent of a node before adding it as a child!";
    assert n != jjtGetParent();
    if (children == null) {
      children = new Node[i + 1];
      children[i] = n;
    } else if (i >= children.length) {
      Node c[] = new Node[i + 1];
      System.arraycopy(children, 0, c, 0, children.length);
      children = c;
      c[i] = n;
    } else if (children[i] != n){// the slot is already used. move it over.
      Node c[] = new Node[children.length + 1];
      if (i > 0) {
        System.arraycopy(children, 0, c, 0, i);
      }
      c[i] = n;
      System.arraycopy(children, i, c, i + 1, children.length - i);
      children = c;

    }
  }

  public Node jjtGetChild(int i) {
    return children[i];
  }

  public int jjtGetNumChildren() {
    return (children == null) ? 0 : children.length;
  }

  public void jjtSetValue(Object value) { this.value = value; }
  public Object jjtGetValue() { return value; }

  public Token jjtGetFirstToken() { return firstToken; }
  public void jjtSetFirstToken(Token token) { this.firstToken = token; }
  public Token jjtGetLastToken() { return lastToken; }
  public void jjtSetLastToken(Token token) { this.lastToken = token; }

  /** Accept the visitor. **/
  public Object jjtAccept(ChunkerVisitor visitor, Object data)
{
    return visitor.visit(this, data);
  }

  /** Accept the visitor. **/
  public Object childrenAccept(ChunkerVisitor visitor, Object data)
{
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        children[i].jjtAccept(visitor, data);
      }
    }
    return data;
  }

    @Override
    public String toString() {
        return ChunkerTreeConstants.jjtNodeName[id] +
            "(" + getStartIndex() + "," + getEndIndex() + ")" +
            "|" + toSource() + "|";
    }

    public String toString(String prefix) { return prefix + toString(); }

  /* Override this method if you want to customize how the node dumps
     out its children. */

  public void dump(String prefix) {
    System.out.println(toString(prefix));
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        SimpleNode n = (SimpleNode)children[i];
        if (n != null) {
          n.dump(prefix + " ");
        }
      }
    }
  }

  public int getId() {
    return id;
  }

  @Override
  public boolean isWellFormed() {
    return wellFormed && junk == null;
  }

  public void setWellFormed(boolean wellFormed) {
    this.wellFormed = wellFormed;
  }

  @Override
  public void addToken(Token token, Node anchor) {
      if (lastToken == token) {
          return;
      }
    if (lastToken == null) {
      lastToken = token;
    } else  if (anchor == null) {
      assert lastToken.next == token : "Do not add tokens without properly linking them; " + lastToken.next + " != " + token;
    } else {
      assert lastToken.next == anchor : "Do not add tokens without properly linking them; " + lastToken.next + " != " + anchor;
      assert anchor.jjtGetLastToken() == token : "Do not add tokens without properly linking them; " + anchor.jjtGetLastToken() + " != " + token;
    }
    assert lastToken.startIndex <= token.startIndex;
    assert lastToken.endIndex <= token.endIndex;
    lastToken = token;
  }

  @Override
  public List<Node> getChildren() {
    return children == null || children.length == 0 ? Collections.emptyList() : Arrays.asList(children);
  }

  @Override
  public void adopt(Node node) {
    Token tok = node.jjtGetLastToken();
    while (tok != node.jjtGetLastToken()) {
      addToken(tok);
      tok = tok.next;
    }
    addToken(tok);
    assert node.jjtGetParent() == null : "Cannot adopt node w/ parent " + node + "; you should jjtree.popNode() an adopted child";
    addChild(node);
  }

  public Token removeToken(Token token) {
    if (token == null) {
      return null;
    }
      // for now, will do nothing, but may need to forcibly disconnect the nodes
    assert token.next == null : "Cannot remove a token that has child tokens";
    Token removeFrom = firstToken;
    while (removeFrom.next != token) {
      removeFrom = removeFrom.next;
      assert removeFrom != null : "Cannot remove " + token + " from " + this;
    }
    removeFrom.next = null;
    lastToken = removeFrom;
    return removeFrom;
  }

  @Override
  public Token addJunk(Token junk) {
    this.junk = junk;
    this.lastToken = junk;
    Token prev = this.lastToken;
    while (this.lastToken.next != null) {
      prev = this.lastToken;
      this.lastToken = this.lastToken.next;
      assert prev.startIndex <= lastToken.startIndex;
      assert prev.endIndex <= lastToken.endIndex;
    }
//    return prev;
      // if returning lastToken checks out, we'll delete most of the crap above
    return this.lastToken;
  }

  public Token getJunk() {
    return junk;
  }

  @Override
  public void removeChild(Node node) {
    int index = indexOf(node);
    if (index == -1) {
      throw new IllegalArgumentException(node + " is not a child of " + this);
    }
    final Node[] newChildren = new Node[children.length - 1];
    if (index > 0) {
      System.arraycopy(children, 0, newChildren, 0, index);
    }
    if (index < children.length-1) {
      System.arraycopy(children, index+1, newChildren, index, children.length - index - 1);
    }
    children = newChildren;
    assert Stream.of(children).noneMatch(Objects::isNull);
  }

  @Override
  public int indexOf(Node node) {
    if (children == null) {
      return -1;
    }
    int index = -1;
    while (++index < children.length) {
      if (children[index] == node) {
        break;
      }
    }
    return index == children.length ? -1 : index;
  }
}

/* JavaCC - OriginalChecksum=576dbec454703e91f98cb96657f48151 (do not edit this line) */
