/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.secretweb.service;

import io.datarouter.secret.service.SecretNamespacer;
import io.datarouter.storage.config.environment.EnvironmentType;
import io.datarouter.storage.config.properties.DatarouterEnvironmentTypeSupplier;
import io.datarouter.web.config.service.ServiceName;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterPropertiesAndServiceSecretNamespacer
implements SecretNamespacer {
    @Inject
    private DatarouterEnvironmentTypeSupplier environmentType;
    @Inject
    private ServiceName serviceName;

    private String getEnvironment() {
        return Objects.requireNonNull(this.environmentType.get());
    }

    public String getAppNamespace() {
        return String.valueOf(this.getEnvironment()) + '/' + Objects.requireNonNull(this.serviceName.get()) + '/';
    }

    public String getSharedNamespace() {
        return String.valueOf(this.getEnvironment()) + '/' + "shared" + '/';
    }

    public boolean isDevelopment() {
        return EnvironmentType.DEVELOPMENT.get().getPersistentString().equals(this.getEnvironment());
    }
}

