/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.DatabeanTool;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldTool;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import io.datarouter.storage.tally.Tally;
import io.datarouter.storage.tally.TallyKey;
import io.datarouter.util.array.ArrayTool;
import io.datarouter.util.bytes.ByteTool;
import io.datarouter.util.bytes.IntegerByteTool;
import io.lettuce.core.KeyValue;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class RedisTallyCodec {
    private static final Tally.TallyFielder SAMPLE_FIELDER = new Tally.TallyFielder();
    private final int version;
    private final PhysicalDatabeanFieldInfo<TallyKey, Tally, Tally.TallyFielder> fieldInfo;

    public RedisTallyCodec(int version, PhysicalDatabeanFieldInfo<?, ?, ?> fieldInfo) {
        this.version = version;
        this.fieldInfo = fieldInfo;
    }

    public byte[] encodeKey(TallyKey pk) {
        byte[] key = FieldTool.getConcatenatedValueBytes((List)pk.getFields());
        byte[] schemaVersion = IntegerByteTool.getRawBytes((int)this.version);
        return ByteTool.concatenate((byte[][])new byte[][]{schemaVersion, key});
    }

    public byte[] encode(Tally databean) {
        return DatabeanTool.getBytes((Databean)databean, (DatabeanFielder)SAMPLE_FIELDER);
    }

    public TallyKey decodeKey(byte[] row) {
        byte[] bytes = Arrays.copyOfRange(row, 4, row.length);
        TallyKey primaryKey = (TallyKey)this.fieldInfo.getPrimaryKeySupplier().get();
        if (ArrayTool.isEmpty((byte[])row)) {
            return primaryKey;
        }
        int byteOffset = 0;
        for (Field field : this.fieldInfo.getPrimaryKeyFields()) {
            int numBytesWithSeparator = field.numBytesWithSeparator(bytes, byteOffset);
            Object value = field.fromBytesWithSeparatorButDoNotSet(bytes, byteOffset);
            field.setUsingReflection((Object)primaryKey, value);
            byteOffset += numBytesWithSeparator;
        }
        return primaryKey;
    }

    public Optional<Long> decodeTallyValue(Optional<byte[]> byteTally) {
        if (byteTally.isEmpty() || byteTally.get().length == 0) {
            return Optional.empty();
        }
        return byteTally.map(String::new).map(String::trim).map(Long::valueOf);
    }

    public Optional<Long> decodeTallyValue(KeyValue<byte[], byte[]> entry) {
        if (!entry.hasValue()) {
            return Optional.empty();
        }
        return this.decodeTallyValue(Optional.of((byte[])entry.getValue()));
    }
}

