/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.DatabeanTool;
import io.datarouter.model.field.FieldSetTool;
import io.datarouter.model.field.FieldTool;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import io.datarouter.util.bytes.ByteTool;
import io.datarouter.util.bytes.IntegerByteTool;
import io.datarouter.util.tuple.Twin;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisDatabeanCodec<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private static final Logger logger = LoggerFactory.getLogger(RedisDatabeanCodec.class);
    private static final int CODEC_VERSION = 1;
    private static final int MAX_REDIS_KEY_SIZE = 65536;
    private final int version;
    private final PhysicalDatabeanFieldInfo<PK, D, F> fieldInfo;

    public RedisDatabeanCodec(int version, PhysicalDatabeanFieldInfo<PK, D, F> fieldInfo) {
        this.version = version;
        this.fieldInfo = fieldInfo;
    }

    public byte[] encodeKey(PK pk) {
        byte[] codecVersion = IntegerByteTool.getRawBytes((int)1);
        byte[] key = FieldTool.getConcatenatedValueBytes((List)pk.getFields());
        byte[] schemaVersion = IntegerByteTool.getRawBytes((int)this.version);
        return ByteTool.concatenate((byte[][])new byte[][]{codecVersion, schemaVersion, key});
    }

    public List<byte[]> encodeKeys(Collection<PK> pks) {
        return Scanner.of(pks).map(this::encodeKey).list();
    }

    public byte[] encode(D databean) {
        return DatabeanTool.getBytes(databean, (DatabeanFielder)this.fieldInfo.getSampleFielder());
    }

    public D decode(byte[] bytes) {
        return (D)((Databean)FieldSetTool.fieldSetFromBytes((Supplier)this.fieldInfo.getDatabeanSupplier(), (Map)this.fieldInfo.getFieldByPrefixedName(), (byte[])bytes));
    }

    public Optional<Twin<byte[]>> encodeIfValid(D databean) {
        byte[] keyBytes;
        try {
            keyBytes = this.encodeKey(databean.getKey());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (keyBytes.length > 65536) {
            this.logBigKey(keyBytes.length, databean.getKey());
            return Optional.empty();
        }
        return Optional.of(new Twin((Object)keyBytes, (Object)this.encode(databean)));
    }

    private void logBigKey(int length, PK pk) {
        String message = String.format("skipping, key too big for redis! length=%s, type=%s, key=%s", length, pk.getClass().getSimpleName(), pk);
        logger.error(message);
    }
}

