/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.client.redis.RedisDatabeanCodec;
import io.datarouter.client.redis.RedisTallyCodec;
import io.datarouter.client.redis.client.RedisOps;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.OptionalScanner;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.tally.TallyKey;
import io.datarouter.util.tuple.Twin;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.Value;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisNodeOps<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private static final Logger logger = LoggerFactory.getLogger(RedisNodeOps.class);
    private final RedisOps ops;
    private final RedisClusterAsyncCommands<byte[], byte[]> client;
    private final RedisDatabeanCodec<PK, D, F> databeanCodec;
    private final RedisTallyCodec tallyCodec;
    private final ExecutorService executor;

    public RedisNodeOps(RedisOps ops, RedisClusterAsyncCommands<byte[], byte[]> client, RedisDatabeanCodec<PK, D, F> databeanCodec, RedisTallyCodec tallyCodec, ExecutorService executor) {
        this.ops = ops;
        this.client = client;
        this.databeanCodec = databeanCodec;
        this.tallyCodec = tallyCodec;
        this.executor = executor;
    }

    public boolean nodeExists(PK key) {
        return this.ops.exists(this.databeanCodec.encodeKey(key));
    }

    public D nodeGet(PK key) {
        return (D)((Databean)this.ops.find(this.databeanCodec.encodeKey(key)).map(this.databeanCodec::decode).orElse(null));
    }

    public List<D> nodeGetMulti(Collection<PK> keys) {
        if (keys.isEmpty()) {
            return List.of();
        }
        return this.ops.mget(this.databeanCodec.encodeKeys(keys)).include(Value::hasValue).map(Value::getValue).map(this.databeanCodec::decode).list();
    }

    public void clientPut(D databean, Config config) {
        this.databeanCodec.encodeIfValid(databean).ifPresent(kvBytes -> config.findTtl().map(Duration::toMillis).ifPresentOrElse(ttlMs -> this.ops.psetex((Twin<byte[]>)kvBytes, (long)ttlMs), () -> this.ops.set((Twin<byte[]>)kvBytes)));
    }

    public void nodePutMulti(Collection<D> databeans, Config config) {
        if (databeans.isEmpty()) {
            return;
        }
        List kvs = Scanner.of(databeans).map(this.databeanCodec::encodeIfValid).concat(OptionalScanner::of).list();
        if (config.findTtl().isPresent()) {
            Scanner.of((Iterable)kvs).parallel(new ParallelScannerContext(this.executor, 16, true)).forEach(kv -> this.ops.psetex((Twin<byte[]>)kv, this.getTtlMs(config)));
        } else {
            this.ops.mset(kvs);
        }
    }

    public void nodeDeleteMulti(Collection<PK> keys) {
        if (keys.isEmpty()) {
            return;
        }
        this.ops.del(this.databeanCodec.encodeKeys(keys));
    }

    public void nodeDelete(PK key) {
        this.ops.del(this.databeanCodec.encodeKey(key));
    }

    public Optional<Long> nodeFindTallyCount(String stringKey) {
        byte[] tallyKeyBytes = this.tallyCodec.encodeKey(new TallyKey(stringKey));
        Optional<byte[]> byteTally = this.ops.find(tallyKeyBytes);
        if (byteTally.isEmpty() || byteTally.get().length == 0) {
            return Optional.empty();
        }
        return byteTally.map(String::new).map(String::trim).map(Long::valueOf);
    }

    public Long nodeIncrementAndGetCount(String stringKey, int delta, Config config) {
        byte[] tallyKeyBytes = this.tallyCodec.encodeKey(new TallyKey(stringKey));
        RedisFuture increment = this.client.incrby((Object)tallyKeyBytes, (long)delta);
        Long expiration = this.getTtlMs(config);
        RedisFuture expire = null;
        if (expiration != null) {
            expire = this.client.pexpire((Object)tallyKeyBytes, expiration.longValue());
        }
        try {
            long count = (Long)increment.get();
            expire.get();
            return count;
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public void nodeDeleteTally(String stringKey) {
        this.ops.del(this.tallyCodec.encodeKey(new TallyKey(stringKey)));
    }

    private Long getTtlMs(Config config) {
        return config.findTtl().map(Duration::toMillis).orElse(Long.MAX_VALUE);
    }
}

