/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.client.redis.client.RedisOptions;
import io.datarouter.storage.client.ClientId;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RedisClientHolder {
    private final RedisOptions redisOptions;
    private final Map<ClientId, StatefulRedisConnection<byte[], byte[]>> redisByClientId;

    @Inject
    public RedisClientHolder(RedisOptions redisOptions) {
        this.redisOptions = redisOptions;
        this.redisByClientId = new ConcurrentHashMap<ClientId, StatefulRedisConnection<byte[], byte[]>>();
    }

    public void registerClient(ClientId clientId) {
        if (this.redisByClientId.containsKey(clientId)) {
            throw new RuntimeException(clientId + " already registered a RedisClient");
        }
        this.redisByClientId.put(clientId, this.buildClient(clientId));
    }

    public StatefulRedisConnection<byte[], byte[]> get(ClientId clientId) {
        return this.redisByClientId.get(clientId);
    }

    private StatefulRedisConnection<byte[], byte[]> buildClient(ClientId clientId) {
        InetSocketAddress address = this.redisOptions.getEndpoint(clientId.getName());
        RedisClient client = RedisClient.create((RedisURI)RedisURI.create((String)address.getHostName(), (int)address.getPort()));
        return client.connect((RedisCodec)ByteArrayCodec.INSTANCE);
    }
}

