/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis;

import io.datarouter.client.redis.RedisClientType;
import io.datarouter.client.redis.RedisNodeFactory;
import io.datarouter.client.redis.client.RedisClientManager;
import io.datarouter.client.redis.config.RedisExecutors;
import io.datarouter.client.redis.node.RedisNode;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.imp.BaseClientNodeFactory;
import io.datarouter.storage.client.imp.TallyClientNodeFactory;
import io.datarouter.storage.client.imp.WrappedNodeFactory;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.adapter.availability.PhysicalMapStorageAvailabilityAdapterFactory;
import io.datarouter.storage.node.adapter.callsite.physical.PhysicalMapStorageCallsiteAdapter;
import io.datarouter.storage.node.adapter.counter.physical.PhysicalMapStorageCounterAdapter;
import io.datarouter.storage.node.adapter.counter.physical.PhysicalTallyStorageCounterAdapter;
import io.datarouter.storage.node.adapter.sanitization.physical.PhysicalTallyStorageSanitizationAdapter;
import io.datarouter.storage.node.adapter.trace.physical.PhysicalMapStorageTraceAdapter;
import io.datarouter.storage.node.adapter.trace.physical.PhysicalTallyStorageTraceAdapter;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.op.raw.TallyStorage;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RedisClientNodeFactory
extends BaseClientNodeFactory
implements TallyClientNodeFactory {
    @Inject
    private PhysicalMapStorageAvailabilityAdapterFactory physicalMapStorageAvailabilityAdapterFactory;
    @Inject
    private RedisClientType redisClientType;
    @Inject
    private RedisClientManager redisClientManager;
    @Inject
    private RedisNodeFactory redisNodeFactory;
    @Inject
    private RedisExecutors.RedisBatchOpExecutor executor;

    public <EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> WrappedNodeFactory<EK, E, PK, D, F, MapStorage.PhysicalMapStorageNode<PK, D, F>> makeWrappedNodeFactory() {
        return new RedisWrappedNodeFactory();
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createTallyNode(NodeParams<PK, D, F> nodeParams) {
        RedisNode<PK, D, F> node = this.redisNodeFactory.createTallyNode(nodeParams);
        return new PhysicalTallyStorageTraceAdapter((TallyStorage.PhysicalTallyStorageNode)new PhysicalTallyStorageCounterAdapter((TallyStorage.PhysicalTallyStorageNode)new PhysicalTallyStorageSanitizationAdapter(node)));
    }

    public class RedisWrappedNodeFactory<EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
    extends WrappedNodeFactory<EK, E, PK, D, F, MapStorage.PhysicalMapStorageNode<PK, D, F>> {
        public MapStorage.PhysicalMapStorageNode<PK, D, F> createNode(EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> nodeParams) {
            return new RedisNode<PK, D, F>(nodeParams, RedisClientNodeFactory.this.redisClientType, RedisClientNodeFactory.this.redisClientManager, nodeParams.getClientId(), (ExecutorService)((Object)RedisClientNodeFactory.this.executor));
        }

        public List<UnaryOperator<MapStorage.PhysicalMapStorageNode<PK, D, F>>> getAdapters() {
            return List.of(PhysicalMapStorageCounterAdapter::new, PhysicalMapStorageTraceAdapter::new, arg_0 -> ((PhysicalMapStorageAvailabilityAdapterFactory)RedisClientNodeFactory.this.physicalMapStorageAvailabilityAdapterFactory).create(arg_0), PhysicalMapStorageCallsiteAdapter::new);
        }
    }
}

