/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.web;

import io.datarouter.client.redis.RedisClientType;
import io.datarouter.client.redis.client.RedisClientManager;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.web.browse.DatarouterClientWebInspector;
import io.datarouter.web.browse.dto.DatarouterWebRequestParamsFactory;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.params.Params;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import redis.clients.jedis.Jedis;

public class RedisWebInspector
implements DatarouterClientWebInspector {
    @Inject
    private RedisClientManager clientManager;
    @Inject
    private DatarouterWebRequestParamsFactory paramsFactory;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private ClientOptions clientOptions;

    public Mav inspectClient(Params params, HttpServletRequest request) {
        DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory = this.paramsFactory;
        datarouterWebRequestParamsFactory.getClass();
        DatarouterWebRequestParamsFactory.DatarouterWebRequestParams clientParams = new DatarouterWebRequestParamsFactory.DatarouterWebRequestParams(datarouterWebRequestParamsFactory, params, RedisClientType.class);
        ClientId clientId = clientParams.getClientId();
        if (clientId == null) {
            return new MessageMav("Client not found");
        }
        String clientName = clientId.getName();
        Map allClientOptions = this.clientOptions.getAllClientOptions(clientName);
        ContainerTag content = (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{this.buildClientPageHeader(clientName), this.buildClientOptionsTable(allClientOptions), this.buildOverview(clientId)}).withClass("container my-3");
        return this.pageFactory.startBuilder(request).withTitle("Datarouter Client - Redis").withContent(content).buildMav();
    }

    private ContainerTag buildOverview(ClientId clientId) {
        ContainerTag infoDiv;
        Throwable throwable = null;
        Object var4_4 = null;
        try (Jedis client = this.clientManager.getJedis(clientId).getResource();){
            infoDiv = TagCreator.pre((String)client.info());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return TagCreator.dl((DomContent[])new DomContent[]{TagCreator.dt((String)"Info:"), TagCreator.dd((DomContent[])new DomContent[]{infoDiv})});
    }
}

