/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.node;

import io.datarouter.client.redis.RedisClientType;
import io.datarouter.client.redis.client.RedisClientManager;
import io.datarouter.client.redis.node.RedisReaderNode;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.JsonDatabeanTool;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.op.raw.TallyStorage;
import io.datarouter.storage.tally.TallyKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.params.SetParams;

public class RedisNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends RedisReaderNode<PK, D, F>
implements MapStorage.PhysicalMapStorageNode<PK, D, F>,
TallyStorage.PhysicalTallyStorageNode<PK, D, F> {
    private static final Logger logger = LoggerFactory.getLogger(RedisNode.class);
    private static final int MAX_REDIS_KEY_SIZE = 65536;

    public RedisNode(NodeParams<PK, D, F> params, RedisClientType redisClientType, RedisClientManager redisClientManager, ClientId clientId) {
        super(params, redisClientType, redisClientManager, clientId);
    }

    public void put(D databean, Config config) {
        if (databean == null) {
            return;
        }
        String key = this.buildRedisKey(databean.getKey());
        if (key.length() > 65536) {
            String jsonKey = JsonDatabeanTool.fieldsToJson((List)databean.getKey().getFields()).toString();
            logger.error("redis object too big for redis! " + databean.getDatabeanName() + ", key: " + jsonKey);
            return;
        }
        Long ttl = null;
        if (config != null && config.getTtl() != null) {
            ttl = this.getTtlMs(config);
        }
        String jsonBean = JsonDatabeanTool.databeanToJsonString(databean, (DatabeanFielder)this.getFieldInfo().getSampleFielder());
        Throwable throwable = null;
        Object var7_9 = null;
        try (Jedis client = this.redisClientManager.getJedis(this.clientId).getResource();){
            if (ttl == null) {
                client.set(key, jsonBean);
            } else {
                client.set(key, jsonBean, new SetParams().xx().px(ttl.longValue()));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void putMulti(Collection<D> databeans, Config config) {
        if (databeans == null || databeans.size() == 0) {
            return;
        }
        if (config != null && config.getTtl() != null) {
            databeans.forEach(databean -> this.put(databean, config));
            return;
        }
        ArrayList<String> keysAndDatabeans = new ArrayList<String>();
        for (Databean databean2 : databeans) {
            String key = this.buildRedisKey(databean2.getKey());
            if (key.length() > 65536) {
                logger.error("redis object too big for redis! " + databean2.getDatabeanName() + ", key: " + key);
                continue;
            }
            String jsonBean = JsonDatabeanTool.databeanToJsonString((Databean)databean2, (DatabeanFielder)this.getFieldInfo().getSampleFielder());
            keysAndDatabeans.add(key);
            keysAndDatabeans.add(jsonBean);
        }
        Throwable throwable = null;
        Iterator<D> iterator = null;
        try (Jedis client = this.redisClientManager.getJedis(this.clientId).getResource();){
            client.mset(keysAndDatabeans.toArray(new String[keysAndDatabeans.size()]));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void deleteAll(Config config) {
        throw new UnsupportedOperationException();
    }

    public void delete(PK key, Config config) {
        if (key == null) {
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (Jedis client = this.redisClientManager.getJedis(this.clientId).getResource();){
            client.del(this.buildRedisKey((PrimaryKey<?>)key));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void deleteMulti(Collection<PK> keys, Config config) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (Jedis client = this.redisClientManager.getJedis(this.clientId).getResource();){
            client.del(this.buildRedisKeys(keys).toArray(new String[keys.size()]));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Long incrementAndGetCount(String key, int delta, Config config) {
        if (key == null) {
            return null;
        }
        String tallyKey = this.buildRedisKey((PrimaryKey<?>)new TallyKey(key));
        Long expiration = this.getTtlMs(config);
        Throwable throwable = null;
        Object var7_8 = null;
        try (Jedis client = this.redisClientManager.getJedis(this.clientId).getResource();){
            if (expiration == null) {
                return (long)client.incrBy(tallyKey, (long)delta);
            }
            Long response = client.incrBy(tallyKey, (long)delta);
            client.pexpire(tallyKey, expiration.longValue());
            return (long)response;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void deleteTally(String key, Config config) {
        if (key == null) {
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (Jedis client = this.redisClientManager.getJedis(this.clientId).getResource();){
            client.del(this.buildRedisKey((PrimaryKey<?>)new TallyKey(key)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Long getTtlMs(Config config) {
        if (config == null) {
            return null;
        }
        return config.getTtl() == null ? Long.MAX_VALUE : config.getTtl().toMillis();
    }
}

