/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.web;

import io.datarouter.client.redis.RedisClientType;
import io.datarouter.client.redis.client.RedisClientManager;
import io.datarouter.client.redis.client.RedisOptions;
import io.datarouter.storage.client.ClientId;
import io.datarouter.web.browse.DatarouterClientWebInspector;
import io.datarouter.web.browse.dto.DatarouterWebRequestParamsFactory;
import io.datarouter.web.config.ServletContextSupplier;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.params.Params;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import redis.clients.jedis.Jedis;

public class RedisWebInspector
implements DatarouterClientWebInspector {
    @Inject
    private RedisOptions options;
    @Inject
    private RedisClientManager clientManager;
    @Inject
    private DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory;
    @Inject
    private ServletContextSupplier servletContext;
    @Inject
    private Bootstrap4PageFactory pageFactory;

    public Mav inspectClient(Params params, HttpServletRequest request) {
        DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory = this.datarouterWebRequestParamsFactory;
        datarouterWebRequestParamsFactory.getClass();
        DatarouterWebRequestParamsFactory.DatarouterWebRequestParams clientParams = new DatarouterWebRequestParamsFactory.DatarouterWebRequestParams(datarouterWebRequestParamsFactory, params, RedisClientType.class);
        ClientId clientId = clientParams.getClientId();
        ContainerTag content = (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)("Datarouter " + clientId.getName())), DatarouterClientWebInspector.buildNav((String)((ServletContext)this.servletContext.get()).getContextPath(), (String)clientId.getName()), TagCreator.h3((String)"Client Summary"), this.buildOverview(clientId)}).withClass("container my-3");
        return this.pageFactory.startBuilder(request).withTitle("Datarouter Client - Redis").withContent(content).buildMav();
    }

    private ContainerTag buildOverview(ClientId clientId) {
        ContainerTag infoDiv;
        String endpoint = this.options.getEndpoint(clientId.getName()).toString();
        Throwable throwable = null;
        Object var5_5 = null;
        try (Jedis client = this.clientManager.getJedis(clientId).getResource();){
            infoDiv = TagCreator.pre((String)client.info());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return TagCreator.dl((DomContent[])new DomContent[]{TagCreator.dt((String)"Endpoint:"), TagCreator.dd((String)endpoint), TagCreator.dt((String)"Redis Info"), TagCreator.dd((DomContent[])new DomContent[]{infoDiv})});
    }
}

