/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.codec;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.storage.util.Subpath;
import io.lettuce.core.KeyValue;
import io.lettuce.core.Value;
import java.util.Optional;

public class RedisTallyCodec {
    public static final String TALLY_CODEC_VERSION = "1";
    private final byte[] pathBytes;

    public RedisTallyCodec(Subpath path) {
        this.pathBytes = StringCodec.UTF_8.encode(path.toString());
    }

    public byte[] encodeId(String id) {
        byte[] idBytes = StringCodec.UTF_8.encode(id);
        return ByteTool.concat((byte[][])new byte[][]{this.pathBytes, idBytes});
    }

    public String decodeId(byte[] bytes) {
        int offset = this.pathBytes.length;
        int length = bytes.length - offset;
        return StringCodec.UTF_8.decode(bytes, offset, length);
    }

    public String decodeId(KeyValue<byte[], byte[]> kv) {
        return Optional.of(kv).map(KeyValue::getKey).map(this::decodeId).orElseThrow();
    }

    public long decodeValue(KeyValue<byte[], byte[]> kv) {
        return Optional.of(kv).filter(Value::hasValue).map(Value::getValue).map(this::decodeValue).orElseThrow();
    }

    public long decodeValue(byte[] bytes) {
        return Optional.of(bytes).map(arg_0 -> ((StringCodec)StringCodec.US_ASCII).decode(arg_0)).map(String::trim).map(Long::valueOf).orElseThrow();
    }
}

