/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.enums.DatarouterEnumTool;
import io.datarouter.enums.PersistentString;
import io.datarouter.storage.client.ClientOptions;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RedisOptions {
    private static final String PREFIX_REDIS = "redis.";
    public static final String PROP_endpoint = "endpoint";
    public static final String PROP_clientMode = "clientMode";
    public static final String PROP_numNodes = "numNodes";
    public static final String PROP_node = "node";
    @Inject
    private ClientOptions clientOptions;

    public Optional<InetSocketAddress> getEndpoint(String clientName) {
        return this.clientOptions.optInetSocketAddress(clientName, RedisOptions.makeRedisKey(PROP_endpoint));
    }

    public RedisClientMode getClientMode(String clientName) {
        return this.clientOptions.optString(clientName, RedisOptions.makeRedisKey(PROP_clientMode)).map(RedisClientMode::fromPersistentStringStatic).orElseThrow(() -> new IllegalArgumentException("clientMode needs to be specified"));
    }

    public List<InetSocketAddress> getNodes(String clientName) {
        return IntStream.range(0, this.getNumNodes(clientName)).mapToObj(index -> "node." + index).map(RedisOptions::makeRedisKey).map(propertyKey -> this.clientOptions.optInetSocketAddress(clientName, propertyKey)).map(Optional::get).collect(Collectors.toList());
    }

    private Integer getNumNodes(String clientName) {
        return this.clientOptions.getRequiredInteger(clientName, RedisOptions.makeRedisKey(PROP_numNodes));
    }

    protected static String makeRedisKey(String propertyKey) {
        return PREFIX_REDIS + propertyKey;
    }

    public static enum RedisClientMode implements PersistentString
    {
        AUTO_DISCOVERY("autoDiscovery", true),
        MULTI_NODE("multiNode", true),
        STANDARD("standard", false);

        private final String persistentString;
        private final boolean isClustered;

        private RedisClientMode(String persistentString, boolean isClustered) {
            this.persistentString = persistentString;
            this.isClustered = isClustered;
        }

        public String getPersistentString() {
            return this.persistentString;
        }

        public boolean isStandard() {
            return !this.isClustered;
        }

        public boolean isClustered() {
            return this.isClustered;
        }

        public static RedisClientMode fromPersistentStringStatic(String string) {
            return (RedisClientMode)((Object)DatarouterEnumTool.findEnumFromString((PersistentString[])RedisClientMode.values(), (String)string).orElseThrow());
        }
    }
}

