/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.client.redis.client.RedisOptions;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RedisClientHolder {
    private final RedisOptions redisOptions;
    private final Map<ClientId, RedisClusterAsyncCommands<byte[], byte[]>> redisByClientId;

    @Inject
    public RedisClientHolder(RedisOptions redisOptions) {
        this.redisOptions = redisOptions;
        this.redisByClientId = new ConcurrentHashMap<ClientId, RedisClusterAsyncCommands<byte[], byte[]>>();
    }

    public void registerClient(ClientId clientId) {
        if (this.redisByClientId.containsKey(clientId)) {
            throw new RuntimeException(clientId + " already registered a RedisClient");
        }
        this.redisByClientId.put(clientId, this.buildClient(clientId));
    }

    public RedisClusterAsyncCommands<byte[], byte[]> get(ClientId clientId) {
        return this.redisByClientId.get(clientId);
    }

    private RedisClusterAsyncCommands<byte[], byte[]> buildClient(ClientId clientId) {
        if (this.getClientMode(clientId).isStandard()) {
            return this.buildRegularClient(clientId);
        }
        return this.buildClusterClient(clientId);
    }

    public RedisOptions.RedisClientMode getClientMode(ClientId clientId) {
        return this.redisOptions.getClientMode(clientId.getName());
    }

    private RedisClusterAsyncCommands<byte[], byte[]> buildRegularClient(ClientId clientId) {
        InetSocketAddress address = this.redisOptions.getEndpoint(clientId.getName()).get();
        RedisClient client = RedisClient.create((RedisURI)RedisURI.create((String)address.getHostName(), (int)address.getPort()));
        return client.connect((RedisCodec)ByteArrayCodec.INSTANCE).async();
    }

    private RedisClusterAsyncCommands<byte[], byte[]> buildClusterClient(ClientId clientId) {
        RedisOptions.RedisClientMode mode = this.redisOptions.getClientMode(clientId.getName());
        ArrayList<RedisURI> redisUris = new ArrayList<RedisURI>();
        if (mode == RedisOptions.RedisClientMode.AUTO_DISCOVERY) {
            InetSocketAddress address2 = this.redisOptions.getEndpoint(clientId.getName()).get();
            String host = address2.getHostName();
            int port = address2.getPort();
            redisUris.add(RedisURI.create((String)host, (int)port));
        } else {
            Scanner.of(this.redisOptions.getNodes(clientId.getName())).map(address -> RedisURI.create((String)address.getHostName(), (int)address.getPort())).distinct().forEach(redisUris::add);
        }
        ClusterTopologyRefreshOptions refreshOptions = ClusterTopologyRefreshOptions.builder().enableAllAdaptiveRefreshTriggers().build();
        ClusterClientOptions clusterClientOptions = ClusterClientOptions.builder().topologyRefreshOptions(refreshOptions).validateClusterNodeMembership(false).build();
        RedisClusterClient redisClusterClient = RedisClusterClient.create(redisUris);
        redisClusterClient.setOptions(clusterClientOptions);
        return redisClusterClient.connect((RedisCodec)ByteArrayCodec.INSTANCE).async();
    }
}

