/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.ratelimiter.storage;

import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.node.factory.TallyNodeFactory;
import io.datarouter.storage.node.op.raw.TallyStorage;
import io.datarouter.storage.tally.Tally;
import io.datarouter.storage.tally.TallyKey;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;

public abstract class BaseTallyDao
extends BaseDao {
    private final TallyStorage<TallyKey, Tally> node;

    public BaseTallyDao(Datarouter datarouter, TallyNodeFactory nodeFactory, ClientId clientId, int version) {
        super(datarouter);
        this.node = (TallyStorage)nodeFactory.createTally(clientId, Tally::new, Tally.TallyFielder::new).withSchemaVersion(version).withTableName("Tally").withIsSystemTable(true).buildAndRegister();
    }

    public Long incrementAndGetCount(String key, int delta, Duration ttl, Duration timeout) {
        Config config = new Config().setTtl(ttl).setTimeout(timeout);
        return this.node.incrementAndGetCount(key, delta, config);
    }

    public Map<String, Long> getMultiTallyCount(Collection<String> keys, Duration ttl, Duration timeout) {
        Config config = new Config().setTtl(ttl).setTimeout(timeout);
        return this.node.getMultiTallyCount(keys, config);
    }
}

