/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.ratelimiter.config;

import io.datarouter.ratelimiter.storage.BaseTallyDao;
import io.datarouter.ratelimiter.storage.DatarouterRateLimiterDao;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.web.config.BaseWebPlugin;
import java.util.List;

public class DatarouterRateLimiterPlugin
extends BaseWebPlugin {
    private DatarouterRateLimiterPlugin(DatarouterRateLimiterDaoModule daosModule) {
        this.setDaosModule(daosModule);
        this.addDatarouterGithubDocLink("datarouter-rate-limiter");
    }

    public static class DatarouterRateLimiterDaoModule
    extends DaosModuleBuilder {
        private final ClientId clientId;
        private final int version;

        public DatarouterRateLimiterDaoModule(ClientId clientId, int version) {
            this.clientId = clientId;
            this.version = version;
        }

        public List<Class<? extends Dao>> getDaoClasses() {
            return List.of(DatarouterRateLimiterDao.class);
        }

        public void configure() {
            this.bind(DatarouterRateLimiterDao.DatarouterRateLimiterDaoParams.class).toInstance((Object)new DatarouterRateLimiterDao.DatarouterRateLimiterDaoParams(this.clientId, this.version));
            this.bind(BaseTallyDao.class).to(DatarouterRateLimiterDao.class);
        }
    }

    public static class DatarouterRateLimiterPluginBuilder {
        private final ClientId clientId;
        private int version = 1;

        public DatarouterRateLimiterPluginBuilder(ClientId clientId) {
            this.clientId = clientId;
        }

        public DatarouterRateLimiterPluginBuilder withVersion(int version) {
            this.version = version;
            return this;
        }

        public DatarouterRateLimiterPlugin build() {
            return new DatarouterRateLimiterPlugin(new DatarouterRateLimiterDaoModule(this.clientId, this.version));
        }
    }
}

