/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.ratelimiter;

import io.datarouter.util.concurrent.ThreadTool;

public class SimpleRateLimiter {
    protected Long nextAllowed;
    private long rateLimitMilliseconds;

    public SimpleRateLimiter(long rateLimitMilliseconds) {
        this.rateLimitMilliseconds = rateLimitMilliseconds;
        this.nextAllowed = System.currentTimeMillis();
    }

    public long getRateLimitMilliseconds() {
        return this.rateLimitMilliseconds;
    }

    public synchronized void next() {
        this.nextAllowed = System.currentTimeMillis() + this.rateLimitMilliseconds;
    }

    public synchronized void customDelay(long rateLimit) {
        this.nextAllowed = System.currentTimeMillis() + rateLimit;
    }

    public synchronized boolean isAllowed(boolean wait) {
        if (this.nextAllowed <= System.currentTimeMillis()) {
            return true;
        }
        if (wait) {
            SimpleRateLimiter.pause(this.nextAllowed - System.currentTimeMillis());
        }
        return this.nextAllowed <= System.currentTimeMillis();
    }

    public synchronized void waitForPermission(boolean evenIfExtended, boolean incrementNext) {
        while (!this.isAllowed(true) && evenIfExtended) {
        }
        if (incrementNext) {
            this.next();
        }
    }

    private static void pause(long milliseconds) {
        if (milliseconds < 1L) {
            return;
        }
        ThreadTool.sleepUnchecked((long)milliseconds);
    }
}

